/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.helper.VecHelper;

public class SkyblockSkyRenderer {
    private static final ResourceLocation textureSkybox = ResourceLocation.parse((String)"botania:textures/misc/skybox.png");
    private static final ResourceLocation textureRainbow = ResourceLocation.parse((String)"botania:textures/misc/rainbow.png");
    private static final ResourceLocation[] planetTextures = new ResourceLocation[]{ResourceLocation.parse((String)"botania:textures/misc/planet0.png"), ResourceLocation.parse((String)"botania:textures/misc/planet1.png"), ResourceLocation.parse((String)"botania:textures/misc/planet2.png"), ResourceLocation.parse((String)"botania:textures/misc/planet3.png"), ResourceLocation.parse((String)"botania:textures/misc/planet4.png"), ResourceLocation.parse((String)"botania:textures/misc/planet5.png")};

    public static void renderExtra(PoseStack ms, ClientLevel world, float partialTicks, float insideVoid) {
        float celAng;
        Tesselator tessellator = Tesselator.getInstance();
        float rain = 1.0f - world.getRainLevel(partialTicks);
        float effCelAng = celAng = world.getTimeOfDay(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float scale = 20.0f;
        float lowA = Math.max(0.0f, effCelAng - 0.3f) * rain;
        float a = Math.max(0.1f, lowA);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        ms.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(a * 4.0f * (1.0f - insideVoid)));
        ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(90.0f), 0.5f, 0.5f, 0.0f));
        block11: for (int p = 0; p < planetTextures.length; ++p) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)planetTextures[p]);
            Matrix4f mat = ms.last().pose();
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, -scale, 100.0f, -scale).setUv(0.0f, 0.0f);
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, scale, 100.0f, -scale).setUv(1.0f, 0.0f);
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, scale, 100.0f, scale).setUv(1.0f, 1.0f);
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, -scale, 100.0f, scale).setUv(0.0f, 1.0f);
            tessellator.clear();
            switch (p) {
                case 0: {
                    ms.mulPose(VecHelper.rotateX(70.0f));
                    scale = 12.0f;
                    continue block11;
                }
                case 1: {
                    ms.mulPose(VecHelper.rotateZ(120.0f));
                    scale = 15.0f;
                    continue block11;
                }
                case 2: {
                    ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(80.0f), 1.0f, 0.0f, 1.0f));
                    scale = 25.0f;
                    continue block11;
                }
                case 3: {
                    ms.mulPose(VecHelper.rotateZ(100.0f));
                    scale = 10.0f;
                    continue block11;
                }
                case 4: {
                    ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(-60.0f), 1.0f, 0.0f, 0.5f));
                    scale = 40.0f;
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.popPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureSkybox);
        scale = 20.0f;
        a = lowA;
        ms.pushPose();
        RenderSystem.blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
        ms.translate(0.0f, -1.0f, 0.0f);
        ms.mulPose(VecHelper.rotateX(220.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        int angles = 90;
        float y = 2.0f;
        float y0 = 0.0f;
        float uPer = 0.0027777778f;
        float anglePer = 360.0f / (float)angles;
        double fuzzPer = Math.PI * 10 / (double)angles;
        float rotSpeed = 1.0f;
        float rotSpeedMod = 0.4f;
        block12: for (int p = 0; p < 3; ++p) {
            float baseAngle = rotSpeed * rotSpeedMod * ((float)ClientTickHandler.ticksInGame + partialTicks);
            ms.mulPose(VecHelper.rotateY(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.25f * rotSpeed * rotSpeedMod));
            Matrix4f mat = ms.last().pose();
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            for (int i = 0; i < angles; ++i) {
                int j = i;
                if (i % 2 == 0) {
                    --j;
                }
                float ang = (float)j * anglePer + baseAngle;
                float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
                float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
                float yo = (float)Math.sin(fuzzPer * (double)j) * 1.0f;
                float ut = ang * uPer;
                if (i % 2 == 0) {
                    tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0 + y, zp).setUv(ut, 1.0f);
                    tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0, zp).setUv(ut, 0.0f);
                    continue;
                }
                tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0, zp).setUv(ut, 0.0f);
                tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0 + y, zp).setUv(ut, 1.0f);
            }
            tessellator.clear();
            switch (p) {
                case 0: {
                    ms.mulPose(VecHelper.rotateX(20.0f));
                    RenderSystem.setShaderColor((float)1.0f, (float)0.4f, (float)0.4f, (float)a);
                    fuzzPer = 43.982297150257104 / (double)angles;
                    rotSpeed = 0.2f;
                    continue block12;
                }
                case 1: {
                    ms.mulPose(VecHelper.rotateX(50.0f));
                    RenderSystem.setShaderColor((float)0.4f, (float)1.0f, (float)0.7f, (float)a);
                    fuzzPer = Math.PI * 6 / (double)angles;
                    rotSpeed = 2.0f;
                }
            }
        }
        ms.popPose();
        ms.pushPose();
        GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureRainbow);
        scale = 10.0f;
        float effCelAng1 = celAng;
        if (effCelAng1 > 0.25f) {
            effCelAng1 = 1.0f - effCelAng1;
        }
        effCelAng1 = 0.25f - Math.min(0.25f, effCelAng1);
        long time = world.getDayTime() + 1000L;
        int day = (int)(time / 24000L);
        Random rand = new Random(day * 255);
        float angle1 = rand.nextFloat() * 360.0f;
        float angle2 = rand.nextFloat() * 360.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(effCelAng1 * (1.0f - insideVoid)));
        ms.mulPose(VecHelper.rotateY(angle1));
        ms.mulPose(VecHelper.rotateZ(angle2));
        Matrix4f mat = ms.last().pose();
        tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < angles; ++i) {
            int j = i;
            if (i % 2 == 0) {
                --j;
            }
            float ang = (float)j * anglePer;
            float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
            float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
            float yo = 0.0f;
            float ut = ang * uPer;
            if (i % 2 == 0) {
                tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0 + y, zp).setUv(ut, 1.0f);
                tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0, zp).setUv(ut, 0.0f);
                continue;
            }
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0, zp).setUv(ut, 0.0f);
            tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX).addVertex(mat, xp, yo + y0 + y, zp).setUv(ut, 1.0f);
        }
        tessellator.clear();
        ms.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - insideVoid));
        GlStateManager._blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
    }

    public static void renderStars(VertexBuffer starVBO, PoseStack ms, Matrix4f projMat, float partialTicks, Runnable resetFog) {
        float celAng;
        FogRenderer.setupNoFog();
        Minecraft mc = Minecraft.getInstance();
        ShaderInstance shader = GameRenderer.getPositionShader();
        float rain = 1.0f - mc.level.getRainLevel(partialTicks);
        float effCelAng = celAng = mc.level.getTimeOfDay(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float alpha = rain * Math.max(0.1f, effCelAng * 2.0f);
        float t = ((float)ClientTickHandler.ticksInGame + partialTicks + 2000.0f) * 0.005f;
        ms.pushPose();
        starVBO.bind();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateY(t * 3.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateY(t));
        RenderSystem.setShaderColor((float)0.5f, (float)1.0f, (float)1.0f, (float)alpha);
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateY(t * 2.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)0.75f, (float)0.75f, (float)alpha);
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateZ(t * 3.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateZ(t));
        RenderSystem.setShaderColor((float)0.5f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(VecHelper.rotateZ(t * 2.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)0.75f, (float)0.75f, (float)(0.25f * alpha));
        starVBO.drawWithShader(ms.last().pose(), projMat, shader);
        ms.popPose();
        ms.popPose();
        VertexBuffer.unbind();
        resetFog.run();
    }
}

