/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.PixieModel;
import vazkii.botania.common.entity.PixieEntity;

public class PixieRenderer
extends MobRenderer<PixieEntity, PixieModel> {
    public PixieRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PixieModel(ctx.bakeLayer(BotaniaModelLayers.PIXIE)), 0.0f);
    }

    public void render(PixieEntity mob, float yaw, float partialTicks, PoseStack pos, MultiBufferSource buffers, int light) {
        ShaderInstance shader = CoreShaders.doppleganger();
        if (shader != null) {
            shader.safeGetUniform("BotaniaDisfiguration").set(0.025f);
            shader.safeGetUniform("BotaniaGrainIntensity").set(0.05f);
        }
        super.render((LivingEntity)mob, yaw, partialTicks, pos, buffers, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PixieEntity entity) {
        return ClientProxy.dootDoot ? ResourceLocation.parse((String)"botania:textures/model/pixie_halloween.png") : ResourceLocation.parse((String)"botania:textures/model/pixie.png");
    }
}

