/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.client.render.entity.BaseSparkRenderer;
import vazkii.botania.common.entity.ManaSparkEntity;

public class ManaSparkRenderer
extends BaseSparkRenderer<ManaSparkEntity> {
    private final TextureAtlasSprite dispersiveIcon;
    private final TextureAtlasSprite dominantIcon;
    private final TextureAtlasSprite recessiveIcon;
    private final TextureAtlasSprite isolatedIcon;

    public ManaSparkRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        this.dispersiveIcon = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/spark_upgrade_rune_dispersive")));
        this.dominantIcon = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/spark_upgrade_rune_dominant")));
        this.recessiveIcon = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/spark_upgrade_rune_recessive")));
        this.isolatedIcon = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/spark_upgrade_rune_isolated")));
    }

    @Override
    public TextureAtlasSprite getSpinningIcon(ManaSparkEntity entity) {
        return switch (entity.getUpgrade()) {
            default -> throw new MatchException(null, null);
            case SparkUpgradeType.NONE -> null;
            case SparkUpgradeType.DISPERSIVE -> this.dispersiveIcon;
            case SparkUpgradeType.DOMINANT -> this.dominantIcon;
            case SparkUpgradeType.RECESSIVE -> this.recessiveIcon;
            case SparkUpgradeType.ISOLATED -> this.isolatedIcon;
        };
    }
}

