/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.MagicLandmineEntity;

public class MagicLandmineRenderer
extends EntityRenderer<MagicLandmineEntity> {
    public MagicLandmineRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(MagicLandmineEntity e, float entityYaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        super.render((Entity)e, entityYaw, partialTicks, ms, buffers, light);
        ms.pushPose();
        AABB aabb = e.getBoundingBox().move(e.position().scale(-1.0));
        float gs = (float)(Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) / 20.0f) + 1.0) * 0.2f + 0.6f;
        int r = (int)(105.0f * gs);
        int g = (int)(25.0f * gs);
        int b = (int)(145.0f * gs);
        int alpha = 32;
        if (e.tickCount < 8) {
            alpha = (int)((float)alpha * Math.min(((float)e.tickCount + partialTicks) / 8.0f, 1.0f));
        } else if (e.tickCount > 47) {
            alpha = (int)((float)alpha * Math.min(1.0f - ((float)(e.tickCount - 47) + partialTicks) / 8.0f, 1.0f));
        }
        ms.translate(aabb.minX, aabb.minY + RenderHelper.getOffY(), aabb.minZ);
        float f = 0.0625f;
        float x = (float)(aabb.getXsize() - (double)f);
        float z = (float)(aabb.getZsize() - (double)f);
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.last().pose();
        RenderHelper.flatRectangle(buffer, mat, f, x, 0.0f, f, z, r, g, b, alpha);
        RenderHelper.incrementOffY();
        ms.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MagicLandmineEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

