/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.armor.ArmorModels;
import vazkii.botania.common.entity.GaiaGuardianEntity;

public class GaiaGuardianRenderer
extends HumanoidMobRenderer<GaiaGuardianEntity, HumanoidModel<GaiaGuardianEntity>> {
    public static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    public static final float DEFAULT_DISFIGURATION = 0.025f;
    private final Model normalModel = (Model)this.getModel();
    private final Model slimModel;

    public GaiaGuardianRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (HumanoidModel)new Model(ctx.bakeLayer(ModelLayers.PLAYER)), 0.0f);
        this.slimModel = new Model(ctx.bakeLayer(ModelLayers.PLAYER_SLIM));
        ArmorModels.init(ctx);
    }

    public void render(@NotNull GaiaGuardianEntity dopple, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        Entity view;
        int invulTime = dopple.getInvulTime();
        ShaderInstance shader = CoreShaders.doppleganger();
        if (shader != null) {
            float disfiguration;
            float grainIntensity;
            if (invulTime > 0) {
                grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
                disfiguration = grainIntensity * 0.3f;
            } else {
                disfiguration = (0.025f + (float)dopple.hurtTime * 0.0425f) / 2.0f;
                grainIntensity = 0.05f + (float)dopple.hurtTime * 0.085f;
            }
            shader.safeGetUniform("BotaniaGrainIntensity").set(grainIntensity);
            shader.safeGetUniform("BotaniaDisfiguration").set(disfiguration);
        }
        this.model = (view = Minecraft.getInstance().getCameraEntity()) instanceof AbstractClientPlayer && DefaultPlayerSkin.get((UUID)view.getUUID()).model().id().equals("slim") ? this.slimModel : this.normalModel;
        super.render((LivingEntity)dopple, yaw, partialTicks, ms, buffers, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GaiaGuardianEntity entity) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity2 = mc.getCameraEntity();
        if (!(entity2 instanceof AbstractClientPlayer)) {
            return DefaultPlayerSkin.get((UUID)entity.getUUID()).texture();
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity2;
        return clientPlayer.getSkin().texture();
    }

    protected boolean isBodyVisible(GaiaGuardianEntity dopple) {
        return true;
    }

    private static class Model
    extends HumanoidModel<GaiaGuardianEntity> {
        Model(ModelPart root) {
            super(root, RenderHelper::getDopplegangerLayer);
        }
    }
}

