/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.render.entity.BaseSparkRenderer;
import vazkii.botania.common.entity.CorporeaSparkEntity;

public class CorporeaSparkRenderer
extends BaseSparkRenderer<CorporeaSparkEntity> {
    private final TextureAtlasSprite corporeaWorldSprite;
    private final TextureAtlasSprite corporeaMasterWorldSprite;
    private final TextureAtlasSprite corporeaCreativeWorldSprite;

    public CorporeaSparkRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        this.corporeaWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/corporea_spark")));
        this.corporeaMasterWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/corporea_spark_master")));
        this.corporeaCreativeWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(BotaniaAPI.botaniaRL("item/corporea_spark_creative")));
    }

    @Override
    public TextureAtlasSprite getBaseIcon(CorporeaSparkEntity entity) {
        if (entity.isCreative()) {
            return this.corporeaCreativeWorldSprite;
        }
        if (entity.isMaster()) {
            return this.corporeaMasterWorldSprite;
        }
        return this.corporeaWorldSprite;
    }
}

