/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.block_entity.TinyPotatoBlockEntity;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ModelManagerAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class TinyPotatoBlockEntityRenderer
implements BlockEntityRenderer<TinyPotatoBlockEntity> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final BlockRenderDispatcher blockRenderDispatcher;

    public TinyPotatoBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public static BakedModel getModelFromDisplayName(Component displayName) {
        StringBuilder nameBuilder = new StringBuilder();
        TinyPotatoBlockItem.isEnchantedName(displayName, nameBuilder);
        return TinyPotatoBlockEntityRenderer.getModel(nameBuilder.toString().toLowerCase(Locale.ROOT));
    }

    private static BakedModel getModel(String name) {
        ModelManager bmm = Minecraft.getInstance().getModelManager();
        Map<ResourceLocation, BakedModel> mm = ((ModelManagerAccessor)bmm).getBakedRegistry();
        BakedModel missing = bmm.getMissingModel();
        ResourceLocation location = TinyPotatoBlockEntityRenderer.taterLocation(name);
        BakedModel model = mm.get(location);
        if (model == null) {
            if (ClientProxy.dootDoot) {
                return mm.getOrDefault(TinyPotatoBlockEntityRenderer.taterLocation(HALLOWEEN), missing);
            }
            return mm.getOrDefault(TinyPotatoBlockEntityRenderer.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static ResourceLocation taterLocation(String name) {
        return BotaniaAPI.botaniaRL("tiny_potato/" + TinyPotatoBlockEntityRenderer.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_").toLowerCase(Locale.ROOT);
    }

    public void render(@NotNull TinyPotatoBlockEntity potato, float partialTicks, PoseStack ms, @NotNull MultiBufferSource buffers, int light, int overlay) {
        boolean render;
        ms.pushPose();
        StringBuilder nameBuilder = new StringBuilder();
        boolean enchanted = TinyPotatoBlockItem.isEnchantedName(potato.name, nameBuilder);
        String name = nameBuilder.toString().toLowerCase(Locale.ROOT);
        RenderType layer = Sheets.translucentCullBlockSheet();
        BakedModel model = TinyPotatoBlockEntityRenderer.getModel(name);
        ms.translate(0.5f, 0.0f, 0.5f);
        Direction potatoFacing = (Direction)potato.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                rotY = 90.0f;
                break;
            }
            case WEST: {
                rotY = 270.0f;
            }
        }
        ms.mulPose(VecHelper.rotateY(-rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.translate(wiggle, up, 0.0f);
        ms.mulPose(VecHelper.rotateZ(rotZ));
        boolean bl = render = !name.equals("mami") && !name.equals("soaryn") && (!name.equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.pushPose();
            ms.translate(-0.5f, 0.0f, -0.5f);
            VertexConsumer buffer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffers, (RenderType)layer, (boolean)true, (boolean)enchanted);
            this.renderModel(ms, buffer, light, overlay, model);
            ms.popPose();
        }
        ms.translate(0.0f, 1.5f, 0.0f);
        ms.pushPose();
        ms.mulPose(VecHelper.rotateZ(180.0f));
        this.renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);
        ms.pushPose();
        ClientXplatAbstractions.INSTANCE.fireRenderTinyPotato(potato, potato.name, partialTicks, ms, buffers, light, overlay);
        ms.popPose();
        ms.popPose();
        ms.mulPose(VecHelper.rotateZ(-rotZ));
        ms.mulPose(VecHelper.rotateY(rotY));
        this.renderName(potato, name, ms, buffers, light);
        ms.popPose();
    }

    private void renderName(TinyPotatoBlockEntity potato, String name, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.getInstance();
        HitResult pos = mc.hitResult;
        if (Minecraft.renderNames() && !name.isEmpty() && pos != null && pos.getType() == HitResult.Type.BLOCK && potato.getBlockPos().equals((Object)((BlockHitResult)pos).getBlockPos())) {
            ms.pushPose();
            ms.translate(0.0f, -0.6f, 0.0f);
            ms.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            float f1 = 0.02666667f;
            ms.scale(-f1, -f1, f1);
            int halfWidth = mc.font.width(potato.name.getString()) / 2;
            float opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.font.drawInBatch(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
            mc.font.drawInBatch(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.translate(0.0f, 14.0f, 0.0f);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.font.width(str) / 2;
                mc.font.drawInBatch(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
                mc.font.drawInBatch(str, (float)(-halfWidth), 0.0f, -1, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, 0, light);
            }
            ms.popPose();
        }
    }

    private void renderItems(TinyPotatoBlockEntity potato, Direction facing, String name, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.pushPose();
        ms.mulPose(VecHelper.rotateZ(180.0f));
        ms.translate(0.0f, -1.0f, 0.0f);
        float s = 0.2857143f;
        ms.scale(s, s, s);
        for (int i = 0; i < potato.inventorySize(); ++i) {
            ItemStack stack = potato.getItemHandler().getItem(i);
            if (stack.isEmpty()) continue;
            ms.pushPose();
            Direction side = Direction.values()[i];
            if (side.getAxis() != Direction.Axis.Y) {
                float sideAngle = side.toYRot() - facing.toYRot();
                side = Direction.fromYRot((double)sideAngle);
            }
            boolean block = stack.getItem() instanceof BlockItem;
            boolean mySon = stack.getItem() instanceof TinyPotatoBlockItem;
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.translate(0.0f, -0.375f, 0.5f);
                    } else if (block) {
                        ms.translate(0.0f, 0.3f, 0.5f);
                    }
                    ms.translate(0.0f, -0.5f, -0.4f);
                    break;
                }
                case DOWN: {
                    ms.translate(0.0f, -2.3f, -0.88f);
                    if (mySon) {
                        ms.translate(0.0f, 1.25f, 0.5f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.6f);
                    break;
                }
                case NORTH: {
                    ms.translate(0.0f, -1.9f, 0.02f);
                    if (mySon) {
                        ms.translate(0.0f, 0.2f, 0.57f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.6f);
                    break;
                }
                case SOUTH: {
                    ms.translate(0.0f, -1.6f, -0.89f);
                    if (mySon) {
                        ms.translate(0.0f, -0.59f, 0.26f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.5f);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.translate(-0.35f, -0.29f, -0.06f);
                    } else if (block) {
                        ms.translate(-0.4f, 0.8f, 0.0f);
                    } else {
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                    }
                    ms.translate(-0.3f, -1.9f, 0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        ms.translate(0.95f, -0.29f, 0.9f);
                        if (stack.has(DataComponents.CUSTOM_NAME)) {
                            StringBuilder childNameBuilder = new StringBuilder();
                            TinyPotatoBlockItem.isEnchantedName(stack.getHoverName(), childNameBuilder);
                            if (childNameBuilder.toString().equals("kingdaddydmac")) {
                                ms.translate(0.55f, 0.0f, 0.0f);
                            }
                        }
                    } else if (block) {
                        ms.translate(1.0f, 0.8f, 1.0f);
                    } else {
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                    }
                    ms.translate(-0.3f, -1.9f, -0.92f);
                }
            }
            if (mySon) {
                ms.scale(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.mulPose(VecHelper.rotateY(180.0f));
            }
            this.renderItem(ms, buffers, potato.getLevel(), light, overlay, stack);
            ms.popPose();
        }
        ms.popPose();
        ms.pushPose();
        if (!name.isEmpty()) {
            ContributorList.firstStart();
            float scale = 0.25f;
            ms.translate(0.0f, 1.0f, 0.0f);
            ms.scale(scale, scale, scale);
            switch (name) {
                case "phi": 
                case "vazkii": {
                    ms.pushPose();
                    ms.translate(-0.08, 0.1, 0.4);
                    ms.mulPose(VecHelper.rotateY(90.0f));
                    ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(20.0f), 1.0f, 0.0f, 1.0f));
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.phiFlowerModel);
                    ms.popPose();
                    if (!name.equals("vazkii")) break;
                    ms.scale(1.25f, 1.25f, 1.25f);
                    ms.mulPose(VecHelper.rotateX(180.0f));
                    ms.mulPose(VecHelper.rotateY(-90.0f));
                    ms.translate(0.2, -1.25, -0.075);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.nerfBatModel);
                    break;
                }
                case "haighyorkie": {
                    ms.scale(1.25f, 1.25f, 1.25f);
                    ms.mulPose(VecHelper.rotateZ(180.0f));
                    ms.mulPose(VecHelper.rotateY(-90.0f));
                    ms.translate(-0.5f, -1.2f, -0.075f);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.goldfishModel);
                    break;
                }
                case "martysgames": 
                case "marty": {
                    ms.scale(0.7f, 0.7f, 0.7f);
                    ms.mulPose(VecHelper.rotateZ(180.0f));
                    ms.translate(-0.3f, -2.7f, -1.2f);
                    ms.mulPose(VecHelper.rotateZ(15.0f));
                    ItemStack stack = new ItemStack((ItemLike)BotaniaItems.infiniteFruit);
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"das boot"));
                    this.renderItem(ms, buffers, potato.getLevel(), light, overlay, stack);
                    break;
                }
                case "jibril": {
                    ms.scale(1.5f, 1.5f, 1.5f);
                    ms.translate(0.0f, 0.8f, 0.0f);
                    FlugelTiaraItem.ClientLogic.renderHalo(null, null, ms, buffers, partialTicks);
                    break;
                }
                case "kingdaddydmac": {
                    ms.scale(0.5f, 0.5f, 0.5f);
                    ms.mulPose(VecHelper.rotateZ(180.0f));
                    ms.mulPose(VecHelper.rotateY(90.0f));
                    ms.pushPose();
                    ms.translate(0.0f, -2.5f, 0.65f);
                    ItemStack ring = new ItemStack((ItemLike)BotaniaItems.manaRing);
                    this.renderItem(ms, buffers, potato.getLevel(), light, overlay, ring);
                    ms.translate(0.0f, 0.0f, -4.0f);
                    this.renderItem(ms, buffers, potato.getLevel(), light, overlay, ring);
                    ms.popPose();
                    ms.translate(1.5, -4.0, -2.5);
                    this.renderBlock(ms, buffers, light, overlay, Blocks.CAKE);
                    break;
                }
                default: {
                    ItemStack icon = ContributorList.getFlower(name);
                    if (icon.isEmpty()) break;
                    ms.mulPose(VecHelper.rotateX(180.0f));
                    ms.mulPose(VecHelper.rotateY(180.0f));
                    ms.translate(0.0, -0.78, -0.5);
                    Minecraft.getInstance().getItemRenderer().renderStatic(icon, ItemDisplayContext.HEAD, light, overlay, ms, buffers, potato.getLevel(), 0);
                }
            }
        }
        ms.popPose();
    }

    private void renderModel(PoseStack ms, MultiBufferSource buffers, int light, int overlay, BakedModel model) {
        this.renderModel(ms, buffers.getBuffer(Sheets.translucentCullBlockSheet()), light, overlay, model);
    }

    private void renderModel(PoseStack ms, VertexConsumer buffer, int light, int overlay, BakedModel model) {
        this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(PoseStack ms, MultiBufferSource buffers, @Nullable Level level, int light, int overlay, ItemStack stack) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.HEAD, light, overlay, ms, buffers, level, 0);
    }

    private void renderBlock(PoseStack ms, MultiBufferSource buffers, int light, int overlay, Block block) {
        this.blockRenderDispatcher.renderSingleBlock(block.defaultBlockState(), ms, buffers, light, overlay);
    }
}

