/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.TeruTeruBozuModel;
import vazkii.botania.common.block.block_entity.TeruTeruBozuBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class TeruTeruBozuBlockEntityRenderer
implements BlockEntityRenderer<TeruTeruBozuBlockEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/teru_teru_bozu.png");
    private static final ResourceLocation textureHalloween = ResourceLocation.parse((String)"botania:textures/model/teru_teru_bozu_halloween.png");
    private final TeruTeruBozuModel model;

    public TeruTeruBozuBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new TeruTeruBozuModel(ctx.bakeLayer(BotaniaModelLayers.TERU_TERU_BOZU));
    }

    public void render(@Nullable TeruTeruBozuBlockEntity tileentity, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean hasWorld;
        ms.pushPose();
        ms.mulPose(VecHelper.rotateX(180.0f));
        double time = (float)ClientTickHandler.ticksInGame + partialTicks;
        boolean bl = hasWorld = tileentity != null && tileentity.getLevel() != null;
        if (hasWorld) {
            time += (double)new Random(tileentity.getBlockPos().hashCode()).nextInt(1000);
        }
        ms.translate(0.5f, -1.25f + (hasWorld ? (float)Math.sin(time * (double)0.01f) * 0.05f : 0.0f), -0.5f);
        if (hasWorld) {
            ms.mulPose(VecHelper.rotateY((float)(time * 0.3)));
            ms.mulPose(VecHelper.rotateZ(4.0f * (float)Math.sin(time * (double)0.05f)));
            float s = 0.75f;
            ms.scale(s, s, s);
        }
        VertexConsumer buffer = buffers.getBuffer(this.model.renderType(ClientProxy.dootDoot ? textureHalloween : texture));
        this.model.renderToBuffer(ms, buffer, light, overlay, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
        ms.popPose();
    }
}

