/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class PetalApothecaryBlockEntityRenderer
implements BlockEntityRenderer<PetalApothecaryBlockEntity> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public PetalApothecaryBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
    }

    public void render(@NotNull PetalApothecaryBlockEntity altar, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean lava;
        ms.pushPose();
        ms.translate(0.5, 1.25, 0.5);
        boolean water = altar.getFluid() == PetalApothecary.State.WATER;
        boolean bl = lava = altar.getFluid() == PetalApothecary.State.LAVA;
        if (water || lava) {
            ms.pushPose();
            float v = 0.125f;
            if (water) {
                int petals = 0;
                for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().getItem(i).isEmpty(); ++i) {
                    ++petals;
                }
                if (petals > 0) {
                    float modifier = 6.0f;
                    float rotationModifier = 0.25f;
                    float radiusBase = 1.2f;
                    float radiusMod = 0.1f;
                    double ticks = (double)((float)ClientTickHandler.ticksInGame + pticks) * 0.5;
                    float offsetPerPetal = 360.0f / (float)petals;
                    ms.pushPose();
                    ms.translate(-0.05f, -0.38f, 0.0f);
                    ms.scale(v, v, v);
                    for (int i = 0; i < petals; ++i) {
                        float offset = offsetPerPetal * (float)i;
                        float deg = (int)(ticks / 0.25 % 360.0 + (double)offset);
                        float rad = VecHelper.toRadians(deg);
                        float radiusX = (float)((double)1.2f + (double)0.1f * Math.sin(ticks / 6.0));
                        float radiusZ = (float)((double)1.2f + (double)0.1f * Math.cos(ticks / 6.0));
                        float x = (float)((double)radiusX * Math.cos(rad));
                        float z = (float)((double)radiusZ * Math.sin(rad));
                        float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                        ms.pushPose();
                        ms.translate(x, y, z);
                        float xRotate = (float)Math.sin(ticks * 0.25) / 2.0f;
                        float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                        float zRotate = (float)Math.cos(ticks * 0.25) / 2.0f;
                        ms.translate(v /= 2.0f, v, v);
                        ms.mulPose(new Quaternionf().rotateAxis(rad, xRotate, yRotate, zRotate));
                        ms.translate(-v, -v, -v);
                        v *= 2.0f;
                        ItemStack stack = altar.getItemHandler().getItem(i);
                        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffers, altar.getLevel(), 0);
                        ms.popPose();
                    }
                    ms.popPose();
                }
            }
            float alpha = lava ? 1.0f : 0.7f;
            ms.translate(-0.5f, -0.3125f, -0.5f);
            ms.mulPose(VecHelper.rotateX(90.0f));
            ms.scale(0.0625f, 0.0625f, 0.0625f);
            TextureAtlasSprite sprite = lava ? this.blockRenderDispatcher.getBlockModel(Blocks.LAVA.defaultBlockState()).getParticleIcon() : this.blockRenderDispatcher.getBlockModel(Blocks.WATER.defaultBlockState()).getParticleIcon();
            int color = lava ? -1 : BiomeColors.getAverageWaterColor((BlockAndTintGetter)altar.getLevel(), (BlockPos)altar.getBlockPos());
            VertexConsumer buffer = buffers.getBuffer(Sheets.translucentCullBlockSheet());
            this.renderIcon(ms, buffer, sprite, color, alpha, overlay, lava ? 0xF000F0 : light);
            ms.popPose();
        }
        ms.popPose();
    }

    private void renderIcon(PoseStack ms, VertexConsumer builder, TextureAtlasSprite sprite, int color, float alpha, int overlay, int light) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f mat = ms.last().pose();
        int start = 3;
        int end = 13;
        builder.addVertex(mat, (float)start, (float)end, 0.0f).setColor(red, green, blue, (int)(alpha * 255.0f)).setUv(sprite.getU((float)start), sprite.getV((float)end)).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, (float)end, (float)end, 0.0f).setColor(red, green, blue, (int)(alpha * 255.0f)).setUv(sprite.getU((float)end), sprite.getV((float)end)).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, (float)end, (float)start, 0.0f).setColor(red, green, blue, (int)(alpha * 255.0f)).setUv(sprite.getU((float)end), sprite.getV((float)start)).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, (float)start, (float)start, 0.0f).setColor(red, green, blue, (int)(alpha * 255.0f)).setUv(sprite.getU((float)start), sprite.getV((float)start)).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }
}

