/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.mixin.ItemEntityAccessor;

public class ManaEnchanterBlockEntityRenderer
implements BlockEntityRenderer<ManaEnchanterBlockEntity> {
    private final TextureAtlasSprite overlaySprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(BotaniaAPI.botaniaRL("block/enchanter_overlay")));
    private ItemEntity item;

    public ManaEnchanterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull ManaEnchanterBlockEntity enchanter, float partTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float alphaMod = 0.0f;
        if (enchanter.stage == ManaEnchanterBlockEntity.State.GATHER_MANA) {
            alphaMod = (float)Math.min(20, enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
            alphaMod = (float)(20 - enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT) {
            alphaMod = 1.0f;
        }
        ms.pushPose();
        if (!enchanter.itemToEnchant.isEmpty()) {
            if (this.item == null) {
                this.item = new ItemEntity(enchanter.getLevel(), (double)enchanter.getBlockPos().getX(), (double)(enchanter.getBlockPos().getY() + 1), (double)enchanter.getBlockPos().getZ(), enchanter.itemToEnchant);
            }
            ((ItemEntityAccessor)this.item).setAge(ClientTickHandler.ticksInGame);
            this.item.setItem(enchanter.itemToEnchant);
            ms.translate(0.5f, 1.25f, 0.5f);
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, partTicks, ms, buffers, light);
            ms.translate(-0.5f, -1.25f, -0.5f);
        }
        ms.mulPose(VecHelper.rotateX(90.0f));
        ms.translate(-2.0f, -2.0f, -0.001f);
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + partTicks) / 8.0) + 1.0) / 5.0 + 0.4) * alphaMod;
        if (alpha > 0.0f) {
            if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT || enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
                float ticks = (float)(enchanter.stageTicks + enchanter.stage3EndTicks) + partTicks;
                float angle = ticks * 2.0f;
                float yTranslation = Math.min(20.0f, ticks) / 20.0f * 1.15f;
                float scale = ticks < 10.0f ? 1.0f : 1.0f - Math.min(20.0f, ticks - 10.0f) / 20.0f * 0.75f;
                ms.translate(2.5f, 2.5f, -yTranslation);
                ms.scale(scale, scale, 1.0f);
                ms.mulPose(VecHelper.rotateZ(angle));
                ms.translate(-2.5f, -2.5f, 0.0f);
            }
            VertexConsumer buffer = buffers.getBuffer(RenderHelper.ENCHANTER);
            RenderHelper.renderIconFullBright(ms, buffer, 0.0f, 0.0f, 5.0f, 5.0f, 0, 0, 16, 16, this.overlaySprite, 0xFFFFFF, alpha, light);
        }
        ms.popPose();
    }
}

