/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.HourglassModel;
import vazkii.botania.common.block.block_entity.HoveringHourglassBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class HoveringHourglassBlockEntityRenderer
implements BlockEntityRenderer<HoveringHourglassBlockEntity> {
    final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/hourglass.png");
    private final HourglassModel model;

    public HoveringHourglassBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new HourglassModel(ctx.bakeLayer(BotaniaModelLayers.HOURGLASS));
    }

    public void render(@Nullable HoveringHourglassBlockEntity hourglass, float ticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float rot;
        int wtime;
        ms.pushPose();
        boolean hasWorld = hourglass != null && hourglass.getLevel() != null;
        int n = wtime = !hasWorld ? 0 : ClientTickHandler.ticksInGame;
        if (wtime != 0) {
            wtime += new Random(hourglass.getBlockPos().hashCode()).nextInt(360);
        }
        float time = wtime == 0 ? 0.0f : (float)wtime + ticks;
        float x = 0.5f + (float)Math.cos(time * 0.05f) * 0.025f;
        float y = 0.55f + (float)(Math.sin(time * 0.04f) + 1.0) * 0.05f;
        float z = 0.5f + (float)Math.sin(time * 0.05f) * 0.025f;
        ItemStack stack = hasWorld ? hourglass.getItemHandler().getItem(0) : ItemStack.EMPTY;
        float activeFraction = stack.isEmpty() ? 0.0f : hourglass.lastFraction + (hourglass.timeFraction - hourglass.lastFraction) * ticks;
        float fract1 = stack.isEmpty() ? 0.0f : activeFraction;
        float fract2 = stack.isEmpty() ? 0.0f : 1.0f - activeFraction;
        ms.translate(x, y, z);
        float f = rot = hasWorld && hourglass.flip ? 180.0f : 1.0f;
        if (hasWorld && hourglass.flipTicks > 0) {
            rot += ((float)hourglass.flipTicks - ticks) * 45.0f;
        }
        ms.mulPose(VecHelper.rotateZ(rot));
        ms.scale(1.0f, -1.0f, -1.0f);
        int color = hasWorld ? hourglass.getColor() : 0;
        float r = (float)(color >> 16) / 255.0f;
        float g = (float)(color >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer buffer = buffers.getBuffer(this.model.renderType(this.texture));
        this.model.render(ms, buffer, light, overlay, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b), fract1, fract2, hasWorld && hourglass.flip);
        ms.popPose();
    }
}

