/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class CorporeaIndexBlockEntityRenderer
implements BlockEntityRenderer<CorporeaIndexBlockEntity> {
    private static final RenderType LAYER = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.parse((String)"botania:textures/model/corporea_index.png"));
    private static final float ANGLE = (float)Math.sin(Math.toRadians(45.0));
    private final ModelPart ring;
    private final ModelPart cube;

    public CorporeaIndexBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(BotaniaModelLayers.CORPOREA_INDEX);
        this.ring = root.getChild("ring");
        this.cube = root.getChild("cube");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("ring", CubeListBuilder.create().addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        root.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return mesh;
    }

    public boolean shouldRenderOffScreen(@NotNull CorporeaIndexBlockEntity blockEntity) {
        return true;
    }

    public void render(@Nullable CorporeaIndexBlockEntity index, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float translation;
        ms.pushPose();
        ms.translate(0.5, 0.0, 0.5);
        float rotation = ((float)ClientTickHandler.ticksInGame + partialTicks) * 2.0f;
        if (index == null) {
            ms.scale(1.3f, 1.3f, 1.3f);
            ms.translate(0.0, -0.1, 0.0);
            translation = 0.0f;
        } else {
            translation = (float)((Math.cos(((float)index.ticksWithCloseby + (index.hasCloseby ? partialTicks : 0.0f)) / 10.0f) * 0.5 + 0.5) * 0.25);
        }
        VertexConsumer buffer = buffers.getBuffer(LAYER);
        ms.pushPose();
        ms.translate(0.0, -1.0, 0.0);
        ms.mulPose(VecHelper.rotateY(rotation));
        ms.translate(0.0, (double)(1.5f + translation / 2.0f), 0.0);
        ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(60.0f), ANGLE, 0.0f, ANGLE));
        this.ring.render(ms, buffer, light, overlay);
        ms.scale(0.875f, 0.875f, 0.875f);
        ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(60.0f), ANGLE, 0.0f, ANGLE));
        ms.mulPose(VecHelper.rotateY(rotation));
        this.ring.render(ms, buffer, light, overlay);
        ms.scale(0.875f, 0.875f, 0.875f);
        ms.mulPose(new Quaternionf().rotateAxis(VecHelper.toRadians(60.0f), ANGLE, 0.0f, ANGLE));
        ms.mulPose(VecHelper.rotateY(rotation));
        this.cube.render(ms, buffer, light, overlay);
        ms.popPose();
        if (index != null && index.closeby > 0.0f) {
            float starScale = 0.02f;
            float starRadius = 2.5f * index.closeby + (index.closeby == 1.0f ? 0.0f : (index.hasCloseby ? partialTicks : -partialTicks)) * 0.2f;
            double rads = (double)(((float)index.ticksWithCloseby + partialTicks) * 2.0f) * Math.PI / 180.0;
            double starX = Math.cos(rads) * (double)starRadius;
            double starZ = Math.sin(rads) * (double)starRadius;
            int color = 0xFF00FF;
            int seed = index.getBlockPos().getX() ^ index.getBlockPos().getY() ^ index.getBlockPos().getZ();
            ms.translate(starX, 0.3, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed, partialTicks);
            ms.translate(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed, partialTicks);
            ms.translate(starX, 0.0, starZ);
            rads = -rads;
            starX = Math.cos(rads) * (double)starRadius;
            starZ = Math.sin(rads) * (double)starRadius;
            ms.translate(starX, 0.0, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed, partialTicks);
            ms.translate(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed, partialTicks);
            ms.translate(starX, 0.0, starZ);
        }
        ms.popPose();
    }
}

