/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.model.BellowsModel;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class BellowsBlockEntityRenderer
implements BlockEntityRenderer<BellowsBlockEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/bellows.png");
    private final BellowsModel model;

    public BellowsBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new BellowsModel(ctx.bakeLayer(BotaniaModelLayers.BELLOWS));
    }

    public void render(@Nullable BellowsBlockEntity bellows, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.pushPose();
        ms.translate(0.5f, 1.5f, 0.5f);
        ms.scale(1.0f, -1.0f, -1.0f);
        float angle = 0.0f;
        if (bellows != null) {
            switch ((Direction)bellows.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case SOUTH: {
                    break;
                }
                case NORTH: {
                    angle = 180.0f;
                    break;
                }
                case EAST: {
                    angle = 270.0f;
                    break;
                }
                case WEST: {
                    angle = 90.0f;
                }
            }
        }
        ms.mulPose(VecHelper.rotateY(angle));
        float fract = Math.max(0.1f, 1.0f - (bellows == null ? 0.0f : bellows.movePos + bellows.moving * f + 0.1f));
        VertexConsumer buffer = buffers.getBuffer(this.model.renderType(texture));
        this.model.render(ms, buffer, light, overlay, 0xFFFFFF, fract);
        ms.popPose();
    }
}

