/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.AvatarModel;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.AvatarBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class AvatarBlockEntityRenderer
implements BlockEntityRenderer<AvatarBlockEntity> {
    private static final float[] ROTATIONS = new float[]{180.0f, 0.0f, 90.0f, 270.0f};
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/model/avatar.png");
    private final AvatarModel model;

    public AvatarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new AvatarModel(context.bakeLayer(BotaniaModelLayers.AVATAR));
    }

    public void render(@Nullable AvatarBlockEntity avatar, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ItemStack stack;
        ms.pushPose();
        Direction facing = avatar != null && avatar.getLevel() != null ? (Direction)avatar.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : Direction.SOUTH;
        ms.translate(0.5f, 1.6f, 0.5f);
        ms.scale(1.0f, -1.0f, -1.0f);
        ms.mulPose(VecHelper.rotateY(ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.get3DDataValue() - 2), 0)]));
        VertexConsumer buffer = buffers.getBuffer(this.model.renderType(texture));
        this.model.renderToBuffer(ms, buffer, light, overlay, 0xFFFFFF);
        if (avatar != null && !(stack = avatar.getItemHandler().getItem(0)).isEmpty()) {
            ms.pushPose();
            float s = 0.6f;
            ms.scale(s, s, s);
            ms.translate(-0.5f, 2.0f, -0.25f);
            ms.mulPose(VecHelper.rotateX(-70.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, overlay, ms, buffers, avatar.getLevel(), 0);
            ms.popPose();
            AvatarWieldable wieldable = XplatAbstractions.INSTANCE.findAvatarWieldable(stack);
            if (wieldable != null) {
                buffer = buffers.getBuffer(RenderType.entityTranslucent((ResourceLocation)wieldable.getOverlayResource(avatar)));
                s = 1.01f;
                ms.pushPose();
                ms.scale(s, s, s);
                ms.translate(0.0f, -0.01f, 0.0f);
                float alpha = (float)Math.sin((double)ClientTickHandler.ticksInGame / 20.0) / 2.0f + 0.5f;
                this.model.renderToBuffer(ms, buffer, 0xF000F0, overlay, FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f));
                ms.popPose();
            }
        }
        ms.popPose();
    }
}

