/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.TaintedBloodPendantItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.mixin.client.MinecraftAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public final class ColorHandler {
    public static void submitBlocks(BlockHandlerConsumer blocks) {
        BlockColor vineColor = (state, world, pos, tint) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.getDefaultColor();
        blocks.register(vineColor, BotaniaBlocks.solidVines);
        blocks.register((state, world, pos, tintIndex) -> {
            BlockEntity te;
            if (tintIndex != 0) {
                return -1;
            }
            Optional<Object> color = Optional.empty();
            if (world != null && pos != null && (te = world.getBlockEntity(pos)) instanceof ManaPoolBlockEntity) {
                ManaPoolBlockEntity pool = (ManaPoolBlockEntity)te;
                color = pool.getColor().map(MysticalPetalItem::getPetalLikeColor);
            }
            if (((ManaPoolBlock)state.getBlock()).variant == ManaPoolBlock.Variant.FABULOUS) {
                float time = ((float)ClientTickHandler.ticksInGame + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) * 0.005f;
                int fabulousColor = Mth.hsvToRgb((float)(time - (float)((int)time)), (float)0.6f, (float)1.0f);
                return color.isEmpty() ? fabulousColor : MathHelper.multiplyColor(fabulousColor, (Integer)color.get());
            }
            return color.orElse(-1);
        }, BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool);
        blocks.register((state, world, pos, tintIndex) -> {
            float time = (float)ClientTickHandler.ticksInGame + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            return Mth.hsvToRgb((float)(time * 5.0f % 360.0f / 360.0f), (float)0.4f, (float)0.9f);
        }, BotaniaBlocks.gaiaSpreader);
        blocks.register((state, world, pos, tintIndex) -> tintIndex == 0 ? MysticalPetalItem.getPetalLikeColor(((PetalBlock)state.getBlock()).color) : -1, BotaniaBlocks.petalBlockWhite, BotaniaBlocks.petalBlockOrange, BotaniaBlocks.petalBlockMagenta, BotaniaBlocks.petalBlockLightBlue, BotaniaBlocks.petalBlockYellow, BotaniaBlocks.petalBlockLime, BotaniaBlocks.petalBlockPink, BotaniaBlocks.petalBlockGray, BotaniaBlocks.petalBlockSilver, BotaniaBlocks.petalBlockCyan, BotaniaBlocks.petalBlockPurple, BotaniaBlocks.petalBlockBlue, BotaniaBlocks.petalBlockBrown, BotaniaBlocks.petalBlockGreen, BotaniaBlocks.petalBlockRed, BotaniaBlocks.petalBlockBlack);
        blocks.register((state, world, pos, tintIndex) -> {
            PlatformBlockEntity camo;
            BlockState camoState;
            BlockEntity tile;
            if (world != null && pos != null && (tile = world.getBlockEntity(pos)) instanceof PlatformBlockEntity && (camoState = (camo = (PlatformBlockEntity)tile).getCamoState()) != null) {
                return camoState.getBlock() instanceof PlatformBlock ? 0xFFFFFF : Minecraft.getInstance().getBlockColors().getColor(camoState, world, pos, tintIndex);
            }
            return 0xFFFFFF;
        }, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.infrangiblePlatform);
    }

    public static void submitItems(ItemHandlerConsumer items) {
        items.register((s, t) -> t == 0 ? Mth.hsvToRgb((float)((float)(ClientTickHandler.ticksInGame * 2 % 360) / 360.0f), (float)0.25f, (float)1.0f) : -1, new ItemLike[]{BotaniaItems.lifeEssence, BotaniaItems.gaiaIngot});
        items.register((stack, tintIndex) -> switch (tintIndex) {
            case 1 -> MysticalPetalItem.getPetalLikeColor(WandOfTheForestItem.getColor1(stack));
            case 2 -> MysticalPetalItem.getPetalLikeColor(WandOfTheForestItem.getColor2(stack));
            default -> -1;
        }, new ItemLike[]{BotaniaItems.twigWand, BotaniaItems.dreamwoodWand});
        items.register((s, t) -> t == 0 ? Minecraft.getInstance().getBlockColors().getColor(((BlockItem)s.getItem()).getBlock().defaultBlockState(), null, null, t) : -1, new ItemLike[]{BotaniaBlocks.petalBlockWhite, BotaniaBlocks.petalBlockOrange, BotaniaBlocks.petalBlockMagenta, BotaniaBlocks.petalBlockLightBlue, BotaniaBlocks.petalBlockYellow, BotaniaBlocks.petalBlockLime, BotaniaBlocks.petalBlockPink, BotaniaBlocks.petalBlockGray, BotaniaBlocks.petalBlockSilver, BotaniaBlocks.petalBlockCyan, BotaniaBlocks.petalBlockPurple, BotaniaBlocks.petalBlockBlue, BotaniaBlocks.petalBlockBrown, BotaniaBlocks.petalBlockGreen, BotaniaBlocks.petalBlockRed, BotaniaBlocks.petalBlockBlack, BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.gaiaSpreader});
        items.register((s, t) -> {
            if (t == 1) {
                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(s);
                return Mth.hsvToRgb((float)0.528f, (float)((float)manaItem.getMana() / (float)manaItem.getMaxMana()), (float)1.0f);
            }
            return -1;
        }, new ItemLike[]{BotaniaItems.manaMirror});
        items.register((s, t) -> {
            if (t == 1) {
                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(s);
                return Mth.hsvToRgb((float)0.528f, (float)((float)manaItem.getMana() / (float)manaItem.getMaxMana()), (float)1.0f);
            }
            return -1;
        }, new ItemLike[]{BotaniaItems.manaTablet});
        items.register((s, t) -> t == 0 ? Mth.hsvToRgb((float)0.55f, (float)(((float)s.getMaxDamage() - (float)s.getDamageValue()) / (float)s.getMaxDamage() * 0.5f), (float)1.0f) : -1, new ItemLike[]{BotaniaItems.spellCloth});
        items.register((s, t) -> {
            if (t != 1) {
                return -1;
            }
            Brew brew = ((BrewItem)s.getItem()).getBrew(s);
            if (brew == BotaniaBrews.fallbackBrew) {
                return s.getItem() instanceof TaintedBloodPendantItem ? 12976142 : 0x989898;
            }
            int color = brew.getColor(s);
            double speed = s.is(BotaniaItems.brewFlask) || s.is(BotaniaItems.brewVial) ? 0.1 : 0.2;
            int add = (int)(Math.sin((double)ClientTickHandler.ticksInGame * speed) * 24.0);
            int r = Math.max(0, Math.min(255, (color >> 16 & 0xFF) + add));
            int g = Math.max(0, Math.min(255, (color >> 8 & 0xFF) + add));
            int b = Math.max(0, Math.min(255, (color & 0xFF) + add));
            return r << 16 | g << 8 | b;
        }, new ItemLike[]{BotaniaItems.bloodPendant, BotaniaItems.incenseStick, BotaniaItems.brewFlask, BotaniaItems.brewVial});
        items.register((s, t) -> {
            ItemStack lens = ManaBlasterItem.getLens(s);
            if (!lens.isEmpty() && t == 0) {
                return ((MinecraftAccessor)Minecraft.getInstance()).getItemColors().getColor(lens, t);
            }
            if (t == 2) {
                BurstProperties props = ((ManaBlasterItem)s.getItem()).getBurstProps((Player)Minecraft.getInstance().player, s, false, InteractionHand.MAIN_HAND);
                float mul = (float)(Math.sin((double)ClientTickHandler.ticksInGame / 5.0) * (double)0.15f);
                int c = (int)(255.0f * mul);
                int r = (props.color >> 16 & 0xFF) + c;
                int g = (props.color >> 8 & 0xFF) + c;
                int b = (props.color & 0xFF) + c;
                int cr = Mth.clamp((int)r, (int)0, (int)255);
                int cg = Mth.clamp((int)g, (int)0, (int)255);
                int cb = Mth.clamp((int)b, (int)0, (int)255);
                return cr << 16 | cg << 8 | cb;
            }
            return -1;
        }, new ItemLike[]{BotaniaItems.manaGun});
        items.register((s, t) -> t == 1 ? Mth.hsvToRgb((float)0.75f, (float)1.0f, (float)(1.5f - (float)Math.min(1.0, Math.sin((double)Util.getMillis() / 100.0) * 0.5 + (double)1.2f))) : -1, new ItemLike[]{BotaniaItems.enderDagger});
        items.register((s, t) -> t == 1 && TerraShattererItem.isEnabled(s) ? Mth.hsvToRgb((float)0.375f, (float)((float)Math.min(1.0, Math.sin((double)Util.getMillis() / 200.0) * 0.5 + 1.0)), (float)1.0f) : -1, new ItemLike[]{BotaniaItems.terraPick});
        ItemColor lensHandler = (s, t) -> t == 0 ? ((LensItem)s.getItem()).getLensColor(s, (Level)Minecraft.getInstance().level) : -1;
        items.register(lensHandler, new ItemLike[]{BotaniaItems.lensNormal, BotaniaItems.lensSpeed, BotaniaItems.lensPower, BotaniaItems.lensTime, BotaniaItems.lensEfficiency, BotaniaItems.lensBounce, BotaniaItems.lensGravity, BotaniaItems.lensMine, BotaniaItems.lensDamage, BotaniaItems.lensPhantom, BotaniaItems.lensMagnet, BotaniaItems.lensExplosive, BotaniaItems.lensInfluence, BotaniaItems.lensWeight, BotaniaItems.lensPaint, BotaniaItems.lensFire, BotaniaItems.lensPiston, BotaniaItems.lensLight, BotaniaItems.lensWarp, BotaniaItems.lensRedirect, BotaniaItems.lensFirework, BotaniaItems.lensFlare, BotaniaItems.lensMessenger, BotaniaItems.lensTripwire, BotaniaItems.lensStorm});
    }

    private ColorHandler() {
    }

    public static interface BlockHandlerConsumer {
        public void register(BlockColor var1, Block ... var2);
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

