/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TerraPlateProcessor
implements IComponentProcessor {
    private TerrestrialAgglomerationRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation id = ResourceLocation.parse((String)variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        this.recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.TERRA_PLATE_TYPE, id);
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            NonNullList list = this.recipe.getIngredients();
            if (index >= 0 && index < list.size()) {
                return IVariable.from((Object)((Ingredient)list.get(index)).getItems(), (HolderLookup.Provider)level.registryAccess());
            }
        }
        return null;
    }
}

