/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.RecipeWithReagent;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public abstract class ReagentRecipeProcessor<T extends RecipeWithReagent>
implements IComponentProcessor {
    protected RecipeHolder<T> recipe;

    public abstract void setup(Level var1, IVariableProvider var2);

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        return switch (key) {
            case "recipe" -> IVariable.wrap((String)this.recipe.id().toString());
            case "reagent" -> PatchouliUtils.interweaveIngredients(List.of(((RecipeWithReagent)this.recipe.value()).getReagent()), level);
            case "output" -> IVariable.from((Object)((RecipeWithReagent)this.recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
            case "heading" -> IVariable.from((Object)((RecipeWithReagent)this.recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName(), (HolderLookup.Provider)level.registryAccess());
            default -> null;
        };
    }
}

