/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class BrewRecipeProcessor
implements IComponentProcessor {
    private BotanicalBreweryRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation id = ResourceLocation.parse((String)variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        this.recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.BREW_TYPE, id);
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            if (key.equals("is_offset")) {
                return IVariable.wrap((Boolean)false);
            }
            return null;
        }
        if (key.equals("heading")) {
            return IVariable.from((Object)Component.translatable((String)"botaniamisc.brewOf", (Object[])new Object[]{Component.translatable((String)this.recipe.getBrew().getTranslationKey())}), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("vial")) {
            return IVariable.from((Object)this.recipe.getOutput(new ItemStack((ItemLike)BotaniaItems.vial)), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("flask")) {
            return IVariable.from((Object)this.recipe.getOutput(new ItemStack((ItemLike)BotaniaItems.flask)), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.startsWith("input")) {
            int indexOffset;
            int requestedIndex = Integer.parseInt(key.substring(5)) - 1;
            int index = requestedIndex - (indexOffset = (6 - this.recipe.getIngredients().size()) / 2);
            if (index < this.recipe.getIngredients().size() && index >= 0) {
                return IVariable.wrapList((Iterable)Arrays.stream(((Ingredient)this.recipe.getIngredients().get(index)).getItems()).map(o -> IVariable.from((Object)o, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
            }
            return null;
        }
        if (key.equals("is_offset")) {
            return IVariable.wrap((Boolean)(this.recipe.getIngredients().size() % 2 == 0 ? 1 : 0));
        }
        return null;
    }
}

