/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    private static boolean crafttweakerInfoNote = false;
    private static boolean inVisualizer;

    public static <T extends Recipe<C>, C extends RecipeInput> T getRecipe(Level level, RecipeType<T> type, ResourceLocation id) {
        Map map = (Map)((Object)BotaniaRecipeTypes.getRecipes(level, type));
        Recipe r = (Recipe)map.get(id);
        if (r != null) {
            return (T)r;
        }
        r = (Recipe)map.get(ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)id.getPath()));
        if (r != null) {
            return (T)r;
        }
        r = (Recipe)map.get(ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)("autogenerated/" + id.getNamespace() + "." + id.getPath())));
        if (r != null) {
            return (T)r;
        }
        BotaniaAPI.LOGGER.warn("Template references nonexistent recipe {} of type {}", (Object)id, type);
        if (!crafttweakerInfoNote) {
            crafttweakerInfoNote = true;
            if (XplatAbstractions.INSTANCE.isModLoaded("crafttweaker")) {
                BotaniaAPI.LOGGER.info("To add a recipe that replaces a builtin recipe with CT, \nadd one with the same type, named the same as the path of the missing recipe.\neg. for recipe {}, add a recipe named \"{}\".", (Object)id, (Object)id.getPath());
            }
        }
        return null;
    }

    public static <T extends Recipe<C>, C extends RecipeInput> List<T> getRecipeGroup(RecipeType<T> type, String group) {
        Map map = (Map)((Object)BotaniaRecipeTypes.getRecipes((Level)Minecraft.getInstance().level, type));
        ArrayList<Recipe> list = new ArrayList<Recipe>();
        for (Recipe value : map.values()) {
            if (!group.equals(value.getGroup())) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            BotaniaAPI.LOGGER.warn("Template references empty group {} of recipe type {}", (Object)group, type);
        }
        return list;
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize, Level level) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).getItems()).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.EMPTY};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.isEmpty()) {
                stacks.add(ingredient.getItems());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i2 = 0; i2 < longestIngredientSize; ++i2) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i2 % stack.length], (HolderLookup.Provider)level.registryAccess()));
            }
        }
        return IVariable.wrapList(list, (HolderLookup.Provider)level.registryAccess());
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, Level level) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.getItems().length).max().orElse(1), level);
    }

    public static boolean isInVisualizer() {
        return inVisualizer;
    }

    public static void setInVisualizer(boolean inVisualization) {
        inVisualizer = inVisualization;
    }
}

