/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import vazkii.botania.common.helper.VecHelper;

public class HourglassModel
extends Model {
    private final ModelPart top;
    private final ModelPart glassT;
    private final ModelPart ring;
    private final ModelPart glassB;
    private final ModelPart bottom;
    private final ModelPart sandT;
    private final ModelPart sandB;

    public HourglassModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.top = root.getChild("top");
        this.glassT = root.getChild("glass_top");
        this.ring = root.getChild("ring");
        this.glassB = root.getChild("glass_bottom");
        this.bottom = root.getChild("bottom");
        this.sandT = root.getChild("sand_top");
        this.sandB = root.getChild("sand_bottom");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("top", CubeListBuilder.create().texOffs(20, 0).addBox(-3.0f, -6.5f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.ZERO);
        root.addOrReplaceChild("glass_top", CubeListBuilder.create().addBox(-2.5f, -5.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.ZERO);
        root.addOrReplaceChild("ring", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.ZERO);
        root.addOrReplaceChild("glass_bottom", CubeListBuilder.create().texOffs(0, 10).addBox(-2.5f, 0.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.ZERO);
        root.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(20, 7).addBox(-3.0f, 5.5f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.ZERO);
        root.addOrReplaceChild("sand_top", CubeListBuilder.create().texOffs(20, 14).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("sand_bottom", CubeListBuilder.create().texOffs(20, 14).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.ZERO);
        return mesh;
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color) {
        this.render(ms, buffer, light, overlay, color, 0.0f, 1.0f, false);
    }

    public void render(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color, float fract1, float fract2, boolean flip) {
        if (flip) {
            float tmp = fract1;
            fract1 = fract2;
            fract2 = tmp;
        }
        float f = 0.0625f;
        int alphaWhite = color | 0xFFFFFF;
        this.ring.render(ms, buffer, light, overlay, alphaWhite);
        this.top.render(ms, buffer, light, overlay, alphaWhite);
        this.bottom.render(ms, buffer, light, overlay, alphaWhite);
        if (fract1 > 0.0f) {
            ms.pushPose();
            if (flip) {
                ms.translate(-2.0f * f, 1.0f * f, -2.0f * f);
            } else {
                ms.mulPose(VecHelper.rotateZ(180.0f));
                ms.translate(-2.0f * f, -5.0f * f, -2.0f * f);
            }
            ms.scale(1.0f, fract1, 1.0f);
            this.sandT.render(ms, buffer, light, overlay, color);
            ms.popPose();
        }
        if (fract2 > 0.0f) {
            ms.pushPose();
            if (flip) {
                ms.translate(-2.0f * f, -5.0f * f, -2.0f * f);
            } else {
                ms.mulPose(VecHelper.rotateZ(180.0f));
                ms.translate(-2.0f * f, 1.0f * f, -2.0f * f);
            }
            ms.scale(1.0f, fract2, 1.0f);
            this.sandB.render(ms, buffer, light, overlay, color);
            ms.popPose();
        }
        this.glassT.render(ms, buffer, light, overlay, alphaWhite);
        this.glassB.render(ms, buffer, light, overlay, alphaWhite);
    }
}

