/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import vazkii.botania.common.helper.VecHelper;

public class BellowsModel
extends Model {
    private final ModelPart top;
    private final ModelPart base;
    private final ModelPart pipe;
    private final ModelPart funnel;

    public BellowsModel(ModelPart root) {
        super(RenderType::entityCutout);
        this.top = root.getChild("top");
        this.base = root.getChild("base");
        this.pipe = root.getChild("pipe");
        this.funnel = root.getChild("funnel");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("top", CubeListBuilder.create().addBox(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 9).addBox(-5.0f, 6.0f, -5.0f, 10.0f, 2.0f, 10.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("pipe", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, 6.0f, -8.0f, 2.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("funnel", CubeListBuilder.create().texOffs(40, 0).addBox(0.0f, 0.0f, 0.0f, 6.0f, 7.0f, 6.0f), PartPose.ZERO);
        return mesh;
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color) {
        this.render(ms, buffer, light, overlay, color, 1.0f);
    }

    public void render(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color, float fract) {
        this.base.render(ms, buffer, light, overlay, color);
        this.pipe.render(ms, buffer, light, overlay, color);
        float mov = (1.0f - fract) * 0.5f;
        ms.translate(0.0f, mov, 0.0f);
        this.top.render(ms, buffer, light, overlay, color);
        ms.translate(0.0f, -mov, 0.0f);
        ms.mulPose(VecHelper.rotateX(180.0f));
        ms.translate(-0.19f, -1.375f, -0.19f);
        ms.scale(1.0f, fract, 1.0f);
        this.funnel.render(ms, buffer, light, overlay, color);
        ms.scale(1.0f, 1.0f / fract, 1.0f);
    }
}

