/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class AvatarModel
extends Model {
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart head;

    public AvatarModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.leftleg = root.getChild("left_leg");
        this.rightarm = root.getChild("right_arm");
        this.leftarm = root.getChild("left_arm");
        this.head = root.getChild("head");
        this.rightleg = root.getChild("right_leg");
        this.body = root.getChild("body");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)3.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)-0.0f, (float)-0.0873f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)-0.0f, (float)0.0873f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)1.5f, (float)18.0f, (float)-0.5f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-1.5f, (float)18.0f, (float)-0.5f));
        return mesh;
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color) {
        this.leftleg.render(ms, buffer, light, overlay, color);
        this.rightarm.render(ms, buffer, light, overlay, color);
        this.leftarm.render(ms, buffer, light, overlay, color);
        this.head.render(ms, buffer, light, overlay, color);
        this.rightleg.render(ms, buffer, light, overlay, color);
        this.body.render(ms, buffer, light, overlay, color);
    }
}

