/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CompositeLensRecipeWrapper
implements ICraftingCategoryExtension<CompositeLensRecipe> {
    private final List<Item> allLenses = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(BotaniaTags.Items.LENS).spliterator(), false).map(ItemStack::new).filter(s -> !((LensItem)s.getItem()).isControlLens((ItemStack)s)).filter(s -> ((LensItem)s.getItem()).isCombinable((ItemStack)s)).map(ItemStack::getItem).toList();

    public void setRecipe(RecipeHolder<CompositeLensRecipe> recipe, @NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper helper, @NotNull IFocusGroup focusGroup) {
        List<Item> possibleFirstLenses = focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).filter(f -> this.allLenses.contains(((ItemStack)f.getTypedValue().getIngredient()).getItem())).map(f -> ((ItemStack)f.getTypedValue().getIngredient()).getItem()).toList();
        if (possibleFirstLenses.isEmpty()) {
            possibleFirstLenses = this.allLenses;
        }
        ArrayList<ItemStack> firstInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (Item firstLens : possibleFirstLenses) {
            ItemStack firstLensStack = new ItemStack((ItemLike)firstLens);
            for (Item secondLens : this.allLenses) {
                ItemStack secondLensStack;
                if (secondLens == firstLens || !((LensItem)firstLens).canCombineLenses(firstLensStack, secondLensStack = new ItemStack((ItemLike)secondLens))) continue;
                firstInput.add(firstLensStack);
                secondInput.add(secondLensStack);
                outputs.add(((LensItem)firstLens).setCompositeLens(firstLensStack.copy(), secondLensStack));
            }
        }
        helper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(firstInput, List.of(new ItemStack((ItemLike)Items.SLIME_BALL)), secondInput), 0, 0);
        helper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
    }
}

