/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class PureDaisyRecipeCategory
implements IRecipeCategory<PureDaisyRecipe> {
    public static final RecipeType<PureDaisyRecipe> TYPE = RecipeType.create((String)"botania", (String)"pure_daisy", PureDaisyRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IPlatformFluidHelper fluidHelper;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper) {
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = Component.translatable((String)"botania.nei.pureDaisy");
        this.overlay = guiHelper.createDrawable(BotaniaAPI.botaniaRL("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy));
        this.fluidHelper = fluidHelper;
    }

    @NotNull
    public RecipeType<PureDaisyRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(PureDaisyRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 17, 0);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PureDaisyRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.buildSlot(recipe.getInput(), builder, RecipeIngredientRole.INPUT, 9, 12);
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy));
        this.buildSlot(recipe.getOutput(), builder, RecipeIngredientRole.OUTPUT, 68, 12);
    }

    private void buildSlot(StateIngredient ingredient, @NotNull IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y) {
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(role, x, y).setFluidRenderer(1000L, false, 16, 16);
        for (BlockState state : ingredient.getDisplayed()) {
            if (state.getFluidState().isEmpty()) continue;
            inputSlotBuilder.addIngredient((IIngredientType)this.fluidHelper.getFluidIngredientType(), this.fluidHelper.create(state.getFluidState().holder(), 1000L));
        }
        ((IRecipeSlotBuilder)inputSlotBuilder.addItemStacks(ingredient.getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(ingredient.descriptionTooltip()));
    }
}

