/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.gui.crafting.AssemblyHaloContainer;
import vazkii.botania.client.integration.jei.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.TerrestrialAgglomerationRecipeCategory;
import vazkii.botania.client.integration.jei.crafting.AncientWillRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.CompositeLensRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.TerraShattererTippingRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.MarimorphosisRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeCategory;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.StateIngredients;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraShattererTippingRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LaputaShardItem;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.xplat.XplatAbstractions;

@JeiPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    private static final ResourceLocation ID = BotaniaAPI.botaniaRL("main");
    private static final Comparator<RecipeHolder<? extends Recipe<?>>> BY_ID = Comparator.comparing(RecipeHolder::id);
    private static final Comparator<RecipeHolder<? extends Recipe<?>>> BY_GROUP = Comparator.comparing(holder -> holder.value().getGroup());
    private static final Comparator<RecipeHolder<? extends OrechidRecipe>> BY_WEIGHT = Comparator.comparing(holder -> ((OrechidRecipe)holder.value()).getWeight()).reversed();
    private static final Comparator<RecipeHolder<ManaInfusionRecipe>> BY_CATALYST = (l, r) -> {
        StateIngredient left = ((ManaInfusionRecipe)l.value()).getRecipeCatalyst();
        StateIngredient right = ((ManaInfusionRecipe)r.value()).getRecipeCatalyst();
        if (left == StateIngredients.NONE) {
            return right == StateIngredients.NONE ? 0 : -1;
        }
        if (right == StateIngredients.NONE) {
            return 1;
        }
        return left.streamBlockStates().map(Object::toString).findFirst().orElse("").compareTo(right.streamBlockStates().map(Object::toString).findFirst().orElse(""));
    };
    private static final HoveredStackGetter HOVERED_STACK_GETTER = new HoveredStackGetter();

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter interpreter = (stack, ctx) -> BaseBrewItem.getSubtype(stack);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.brewVial, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.brewFlask, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.incenseStick, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.bloodPendant, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.flightTiara, (stack, ctx) -> String.valueOf(FlugelTiaraItem.getVariant(stack)));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.laputaShard, (stack, ctx) -> String.valueOf(LaputaShardItem.getShardLevel(stack)));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.terraPick, (stack, ctx) -> {
            if (ctx == UidContext.Recipe) {
                return String.valueOf(TerraShattererItem.isTipped(stack));
            }
            return String.valueOf(TerraShattererItem.getLevel(stack)) + TerraShattererItem.isTipped(stack);
        });
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)BotaniaItems.manaTablet, (stack, ctx) -> {
            int mana = XplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
            return String.valueOf(mana) + ManaTabletItem.isStackCreative(stack);
        });
        for (Item item : new Item[]{BotaniaItems.manaRing, BotaniaItems.manaRingGreater}) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, (stack, ctx) -> {
                int mana = XplatAbstractions.INSTANCE.findManaItem((ItemStack)stack).getMana();
                return String.valueOf(mana);
            });
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PureDaisyRecipeCategory(registry.getJeiHelpers().getGuiHelper(), registry.getJeiHelpers().getPlatformFluidHelper()), new ManaPoolRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PetalApothecaryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RunicAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ElvenTradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BreweryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidIgnemRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new MarimorphosisRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new TerrestrialAgglomerationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(AncientWillRecipe.class, (ICraftingCategoryExtension)new AncientWillRecipeWrapper());
        registration.getCraftingCategory().addExtension(TerraShattererTippingRecipe.class, (ICraftingCategoryExtension)new TerraShattererTippingRecipeWrapper());
        registration.getCraftingCategory().addExtension(CompositeLensRecipe.class, (ICraftingCategoryExtension)new CompositeLensRecipeWrapper());
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        registry.addRecipes(BreweryRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.BREW_TYPE, BY_ID));
        registry.addRecipes(PureDaisyRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.PURE_DAISY_TYPE, BY_ID));
        registry.addRecipes(PetalApothecaryRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.PETAL_TYPE, BY_ID));
        registry.addRecipes(ElvenTradeRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ELVEN_TRADE_TYPE, BY_ID));
        registry.addRecipes(RunicAltarRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.RUNE_TYPE, BY_ID));
        registry.addRecipes(ManaPoolRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.MANA_INFUSION_TYPE, BY_CATALYST.thenComparing(BY_GROUP).thenComparing(BY_ID)));
        registry.addRecipes(TerrestrialAgglomerationRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.TERRA_PLATE_TYPE, BY_ID));
        Comparator<RecipeHolder<? extends Recipe<?>>> comp = BY_WEIGHT.thenComparing(BY_ID);
        registry.addRecipes(OrechidRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ORECHID_TYPE, comp));
        registry.addRecipes(OrechidIgnemRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.ORECHID_IGNEM_TYPE, comp));
        registry.addRecipes(MarimorphosisRecipeCategory.TYPE, JEIBotaniaPlugin.sortRecipes(BotaniaRecipeTypes.MARIMORPHOSIS_TYPE, comp));
    }

    private static <T extends Recipe<C>, C extends RecipeInput> List<T> sortRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, Comparator<? super RecipeHolder<T>> comparator) {
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(type).stream().sorted(comparator).map(RecipeHolder::value).toList();
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(AssemblyHaloContainer.class, null, RecipeTypes.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.brewery), new RecipeType[]{BreweryRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.alfPortal), new RecipeType[]{ElvenTradeRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.manaPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.dilutedPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.fabulousPool), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
        for (Block apothecary : BotaniaBlocks.ALL_APOTHECARIES) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)apothecary), new RecipeType[]{PetalApothecaryRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechid), new RecipeType[]{OrechidRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidFloating), new RecipeType[]{OrechidRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidIgnem), new RecipeType[]{OrechidIgnemRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechidIgnemFloating), new RecipeType[]{OrechidIgnemRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosis), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisChibi), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisFloating), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.marimorphosisChibiFloating), new RecipeType[]{MarimorphosisRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisyFloating), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.runeAltar), new RecipeType[]{RunicAltarRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaBlocks.terraPlate), new RecipeType[]{TerrestrialAgglomerationRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaItems.autocraftingHalo), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BotaniaItems.craftingHalo), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        for (RecipeHolder<ElvenTradeRecipe> recipe : AlfheimPortalBlockEntity.elvenTradeRecipes((Level)Minecraft.getInstance().level)) {
            if (recipe.value() instanceof LexiconElvenTradeRecipe) continue;
            NonNullList<Ingredient> inputs = ((ElvenTradeRecipe)recipe.value()).getIngredients();
            List<ItemStack> outputs = ((ElvenTradeRecipe)recipe.value()).getOutputs();
            if (inputs.size() != 1 || outputs.size() != 1 || !((ElvenTradeRecipe)recipe.value()).containsItem(outputs.getFirst())) continue;
            recipeRegistry.hideRecipes(ElvenTradeRecipeCategory.TYPE, List.of((ElvenTradeRecipe)recipe.value()));
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        recipeManager.byKey(BotaniaAPI.botaniaRL("petal_apothecary/daybloom_motif")).ifPresent(r -> {
            Recipe patt0$temp = r.value();
            if (patt0$temp instanceof PetalApothecaryRecipe) {
                PetalApothecaryRecipe pr = (PetalApothecaryRecipe)patt0$temp;
                recipeRegistry.hideRecipes(PetalApothecaryRecipeCategory.TYPE, List.of(pr));
            }
        });
        recipeManager.byKey(BotaniaAPI.botaniaRL("petal_apothecary/nightshade_motif")).ifPresent(r -> {
            Recipe patt0$temp = r.value();
            if (patt0$temp instanceof PetalApothecaryRecipe) {
                PetalApothecaryRecipe pr = (PetalApothecaryRecipe)patt0$temp;
                recipeRegistry.hideRecipes(PetalApothecaryRecipeCategory.TYPE, List.of(pr));
            }
        });
        JEIBotaniaPlugin.HOVERED_STACK_GETTER.jeiRuntimeRef = new WeakReference<IJeiRuntime>(jeiRuntime);
        if (!CorporeaInputHandler.hoveredStackGetters.contains(HOVERED_STACK_GETTER)) {
            CorporeaInputHandler.hoveredStackGetters.add(HOVERED_STACK_GETTER);
        }
        CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(gui -> gui instanceof IRecipesGui);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    private static class HoveredStackGetter
    implements Supplier<ItemStack> {
        WeakReference<IJeiRuntime> jeiRuntimeRef;

        private HoveredStackGetter() {
        }

        @Override
        public ItemStack get() {
            IJeiRuntime jeiRuntime = (IJeiRuntime)this.jeiRuntimeRef.get();
            if (jeiRuntime == null) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> (ItemStack)jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK), () -> jeiRuntime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null), () -> (ItemStack)jeiRuntime.getBookmarkOverlay().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK), () -> ItemStack.EMPTY});
        }
    }
}

