/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.ManaWidget;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.crafting.StateIngredients;

public class ManaInfusionEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = BotaniaAPI.botaniaRL("textures/gui/pure_daisy_overlay.png");
    private static final EmiStack POOL;
    private final int mana;

    public ManaInfusionEmiRecipe(RecipeHolder<? extends ManaInfusionRecipe> recipe) {
        super(BotaniaEmiPlugin.MANA_INFUSION, recipe);
        this.input = ((ManaInfusionRecipe)recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
        if (((ManaInfusionRecipe)recipe.value()).getRecipeCatalyst() != StateIngredients.NONE) {
            this.catalysts = List.of(EmiIngredient.of(((ManaInfusionRecipe)recipe.value()).getRecipeCatalyst().getDisplayed().stream().map(s -> EmiStack.of((ItemLike)s.getBlock())).toList()));
        }
        this.output = List.of(EmiStack.of((ItemStack)((ManaInfusionRecipe)recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
        this.mana = ((ManaInfusionRecipe)recipe.value()).getManaToConsume();
    }

    public int getDisplayHeight() {
        return 65;
    }

    public int getDisplayWidth() {
        return 116;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 28, 0, 65, 44, 0, 0));
        widgets.add((Widget)new ManaWidget(7, 50, this.mana, 100000));
        widgets.addSlot((EmiIngredient)this.input.get(0), 21, 13).drawBack(false);
        widgets.addSlot((EmiIngredient)POOL, 50, 13).catalyst(true).drawBack(false);
        if (!this.catalysts.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.catalysts.get(0), 0, 13).catalyst(true).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 79, 13).drawBack(false).recipeContext((EmiRecipe)this);
    }

    static {
        ItemStack stack = new ItemStack((ItemLike)BotaniaBlocks.manaPool);
        stack.set(BotaniaDataComponents.RENDER_FULL, (Object)Unit.INSTANCE);
        POOL = EmiStack.of((ItemStack)stack);
    }
}

