/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.bag;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.bag.FlowerPouchContainer;
import vazkii.botania.common.item.FlowerPouchItem;

public class FlowerPouchGui
extends AbstractContainerScreen<FlowerPouchContainer> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"botania:textures/gui/flower_bag.png");

    public FlowerPouchGui(FlowerPouchContainer container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        this.imageHeight += 36;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        PoseStack ms = gui.pose();
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        gui.blit(texture, k, l, 0, 0, this.imageWidth, this.imageHeight);
        for (Slot slot : ((FlowerPouchContainer)this.menu).slots) {
            if (slot.container != ((FlowerPouchContainer)this.menu).flowerBagInv) continue;
            int x = this.leftPos + slot.x;
            int y = this.topPos + slot.y;
            if (!slot.hasItem()) {
                ItemStack missingFlower = new ItemStack((ItemLike)FlowerPouchItem.getFlowerForSlot(slot.index));
                RenderHelper.renderGuiItemAlpha(missingFlower, x, y, 95, mc.getItemRenderer());
                continue;
            }
            if (slot.getItem().getCount() != 1) continue;
            ms.pushPose();
            ms.translate(0.0f, 0.0f, 200.0f);
            gui.drawString(mc.font, "1", x + 11, y + 9, 0xFFFFFF);
            ms.popPose();
        }
    }
}

