/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.bag;

import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.FlowerPouchItem;

public class FlowerPouchContainer
extends AbstractContainerMenu {
    private final ItemStack bag;
    public final Container flowerBagInv;

    public FlowerPouchContainer(int windowId, Inventory playerInv, boolean isMainHand) {
        super(BotaniaItems.FLOWER_BAG_CONTAINER, windowId);
        int col;
        int row;
        this.bag = playerInv.player.getItemInHand(isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        this.flowerBagInv = !playerInv.player.level().isClientSide ? FlowerPouchItem.getInventory(this.bag) : new SimpleContainer(32);
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 8; ++col) {
                final int slot = col + row * 8;
                this.addSlot(new Slot(this, this.flowerBagInv, slot, 17 + col * 18, 26 + row * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return stack.is(FlowerPouchItem.getFlowerForSlot(slot));
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (playerInv.getItem(i) == this.bag) {
                this.addSlot(new SlotLocked((Container)playerInv, i, 8 + i * 18, 178));
                continue;
            }
            this.addSlot(new Slot((Container)playerInv, i, 8 + i * 18, 178));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return !main.isEmpty() && main == this.bag || !off.isEmpty() && off == this.bag;
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex < 32) {
                if (!this.moveItemStackTo(itemstack1, 32, 68, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Slot destination;
                Block b = Block.byItem((Item)itemstack.getItem());
                int slotId = -1;
                if (b instanceof BotaniaDoubleFlowerBlock) {
                    BotaniaDoubleFlowerBlock flower = (BotaniaDoubleFlowerBlock)b;
                    slotId = 16 + flower.color.getId();
                } else if (b instanceof BotaniaFlowerBlock) {
                    BotaniaFlowerBlock flower = (BotaniaFlowerBlock)b;
                    slotId = flower.color.getId();
                }
                if (slotId >= 0 && slotId < 32 && (destination = (Slot)this.slots.get(slotId)).mayPlace(itemstack) && !this.moveItemStackTo(itemstack1, slotId, slotId + 1, true)) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

