/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.network.clientbound.UpdateItemsRemainingPacket;
import vazkii.botania.xplat.XplatAbstractions;

public final class ItemsRemainingRenderHandler {
    private static final int maxTicks = 30;
    private static final int leaveTicks = 20;
    private static ItemStack stack = ItemStack.EMPTY;
    @Nullable
    private static Component customString;
    private static int ticks;
    private static int count;

    public static void render(GuiGraphics gui, float partTicks) {
        PoseStack ms = gui.pose();
        if (ticks > 0 && !stack.isEmpty()) {
            int pos = 30 - ticks;
            Minecraft mc = Minecraft.getInstance();
            int x = mc.getWindow().getGuiScaledWidth() / 2 + 10 + Math.max(0, pos - 20);
            int y = mc.getWindow().getGuiScaledHeight() / 2;
            int start = 10;
            float alpha = (float)ticks + partTicks > (float)start ? 1.0f : ((float)ticks + partTicks) / (float)start;
            int xp = x + (int)(16.0f * (1.0f - alpha));
            ms.pushPose();
            ms.translate((float)xp, (float)y, 0.0f);
            ms.scale(alpha, 1.0f, 1.0f);
            gui.renderItem(stack, 0, 0);
            ms.popPose();
            MutableComponent text = Component.empty();
            if (customString == null) {
                if (!stack.isEmpty()) {
                    text = stack.getHoverName().copy().withStyle(ChatFormatting.GREEN);
                    if (count >= 0) {
                        int max = stack.getMaxStackSize();
                        int stacks = count / max;
                        int rem = count % max;
                        if (stacks == 0) {
                            text = Component.literal((String)Integer.toString(count));
                        } else {
                            MutableComponent stacksText = Component.literal((String)Integer.toString(stacks)).withStyle(ChatFormatting.AQUA);
                            MutableComponent maxText = Component.literal((String)Integer.toString(max)).withStyle(ChatFormatting.GRAY);
                            MutableComponent remText = Component.literal((String)Integer.toString(rem)).withStyle(ChatFormatting.YELLOW);
                            text = Component.literal((String)(count + " (")).append((Component)stacksText).append("*").append((Component)maxText).append("+").append((Component)remText).append(")");
                        }
                    } else if (count == -1) {
                        text = Component.literal((String)"\u221e");
                    }
                }
            } else {
                text = customString;
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            gui.drawString(mc.font, (Component)text, x + 20, y + 6, color);
        }
    }

    public static void tick() {
        if (ticks > 0) {
            --ticks;
        }
    }

    public static void send(@Nullable Player player, ItemStack stack, int count) {
        ItemsRemainingRenderHandler.send(player, stack, count, null);
    }

    public static void set(ItemStack stack, int count, @Nullable Component str) {
        ItemsRemainingRenderHandler.stack = stack;
        ItemsRemainingRenderHandler.count = count;
        customString = str;
        ticks = stack.isEmpty() ? 0 : 30;
    }

    public static void send(@Nullable Player entity, ItemStack stack, int count, @Nullable Component str) {
        XplatAbstractions.INSTANCE.sendToPlayer(entity, new UpdateItemsRemainingPacket(stack, count, str));
    }

    public static void send(Player player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !pattern.matcher(stack.getDescriptionId()).find()) continue;
            count += stack.getCount();
        }
        ItemsRemainingRenderHandler.send(player, displayStack, count, null);
    }
}

