/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.BotaniaParticles;

public class WispParticleData
implements ParticleOptions {
    public static final MapCodec<WispParticleData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.b)), (App)Codec.FLOAT.fieldOf("maxAgeMul").forGetter(d -> Float.valueOf(d.maxAgeMul)), (App)Codec.BOOL.fieldOf("depthTest").forGetter(d -> d.depthTest), (App)Codec.BOOL.fieldOf("noClip").forGetter(d -> d.noClip), (App)Codec.FLOAT.optionalFieldOf("gravity", (Object)Float.valueOf(0.0f)).forGetter(d -> Float.valueOf(d.gravity))).apply((Applicative)instance, WispParticleData::new));
    public static final StreamCodec<ByteBuf, WispParticleData> STREAM_CODEC = StreamCodec.of((buf, d) -> {
        buf.writeFloat(d.size);
        buf.writeFloat(d.r);
        buf.writeFloat(d.g);
        buf.writeFloat(d.b);
        buf.writeFloat(d.maxAgeMul);
        buf.writeBoolean(d.depthTest);
        buf.writeBoolean(d.noClip);
        buf.writeFloat(d.gravity);
    }, buf -> new WispParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean(), buf.readFloat()));
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final boolean noClip;
    public final float gravity;

    public static WispParticleData wisp(float size, float r, float g, float b) {
        return WispParticleData.wisp(size, r, g, b, 1.0f);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul) {
        return WispParticleData.wisp(size, r, g, b, maxAgeMul, true);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, boolean depth) {
        return WispParticleData.wisp(size, r, g, b, 1.0f, depth);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        return WispParticleData.wisp(size, r, g, b, maxAgeMul, depthTest, 0.0f);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul, float gravity) {
        return WispParticleData.wisp(size, r, g, b, maxAgeMul, true, gravity);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul, boolean depthTest, float gravity) {
        return new WispParticleData(size, r, g, b, maxAgeMul, depthTest, false, gravity);
    }

    private WispParticleData(float size, float r, float g, float b, float maxAgeMul, boolean depthTest, boolean noClip, float gravity) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.noClip = noClip;
        this.gravity = gravity;
    }

    public WispParticleData withNoClip(boolean v) {
        if (this.noClip == v) {
            return this;
        }
        return new WispParticleData(this.size, this.r, this.g, this.b, this.maxAgeMul, this.depthTest, v, this.gravity);
    }

    @NotNull
    public ParticleType<WispParticleData> getType() {
        return BotaniaParticles.WISP;
    }
}

