/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FXWisp
extends TextureSheetParticle {
    private final boolean depthTest;
    private final float moteParticleScale;
    private final int moteHalfLife;
    public static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableDepthTest();
            return FXWisp.beginRenderCommon(tesselator, textureManager);
        }

        public String toString() {
            return "botania:wisp";
        }
    };
    public static final ParticleRenderType DIW_RENDER = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.disableDepthTest();
            return FXWisp.beginRenderCommon(tesselator, textureManager);
        }

        public String toString() {
            return "botania:depth_ignoring_wisp";
        }
    };

    public FXWisp(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean depthTest, float maxAgeMul, boolean noClip, float g) {
        super(world, d, d1, d2);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.alpha = 0.375f;
        this.gravity = g;
        this.moteParticleScale = this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f * size;
        this.lifetime = (int)(28.0 / (Math.random() * 0.3 + 0.7) * (double)maxAgeMul);
        this.depthTest = depthTest;
        this.moteHalfLife = this.lifetime / 2;
        this.setSize(0.01f, 0.01f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.hasPhysics = !noClip;
    }

    public float getQuadSize(float p_217561_1_) {
        float agescale = (float)this.age / (float)this.moteHalfLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        this.quadSize = this.moteParticleScale * agescale * 0.5f;
        return this.quadSize;
    }

    protected int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.depthTest ? NORMAL_RENDER : DIW_RENDER;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        if (this.gravity == 0.0f) {
            this.xd *= 0.98;
            this.yd *= 0.98;
            this.zd *= 0.98;
        }
    }

    public void setGravity(float value) {
        this.gravity = value;
    }

    private static BufferBuilder beginRenderCommon(Tesselator tesselator, TextureManager textureManager) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
        AbstractTexture tex = textureManager.getTexture(TextureAtlas.LOCATION_PARTICLES);
        ClientXplatAbstractions.INSTANCE.setFilterSave(tex, true, false);
        return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
    }

    private static void endRenderCommon() {
        AbstractTexture tex = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
        ClientXplatAbstractions.INSTANCE.restoreLastFilter(tex);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }
}

