/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.DelegatedVertexConsumer;
import vazkii.botania.client.render.block_entity.PylonBlockEntityRenderer;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ItemRendererAccessor;
import vazkii.botania.mixin.client.RenderTypeAccessor;

public final class RenderHelper
extends RenderType {
    private static final RenderType STAR;
    public static final RenderType RECTANGLE;
    public static final RenderType CIRCLE;
    public static final RenderType RED_STRING;
    public static final RenderType LINE_1_NO_DEPTH;
    public static final RenderType LINE_4_NO_DEPTH;
    public static final RenderType LINE_5_NO_DEPTH;
    public static final RenderType LINE_8_NO_DEPTH;
    public static final RenderType SPARK;
    public static final RenderType LIGHT_RELAY;
    public static final RenderType ICON_OVERLAY;
    public static final RenderType BABYLON_ICON;
    public static final RenderType MANA_POOL_WATER;
    public static final RenderType TERRA_PLATE;
    public static final RenderType ENCHANTER;
    public static final RenderType HALO;
    public static final RenderType MANA_PYLON_GLOW;
    public static final RenderType NATURA_PYLON_GLOW;
    public static final RenderType GAIA_PYLON_GLOW;
    public static final RenderType MANA_PYLON_GLOW_DIRECT;
    public static final RenderType NATURA_PYLON_GLOW_DIRECT;
    public static final RenderType GAIA_PYLON_GLOW_DIRECT;
    public static final RenderType ASTROLABE_PREVIEW;
    public static final RenderType STARFIELD;
    public static final RenderType LIGHTNING;
    public static final RenderType TRANSLUCENT;
    private static final int ITEM_AND_PADDING_WIDTH = 20;
    private static final double INITIAL_OFFSET = 0.005;
    private static final double OFFSET_INCREMENT = 0.001;
    private static double offY;
    private static final Function<ResourceLocation, RenderType> DOPPLEGANGER;

    public static double getOffY() {
        return offY;
    }

    public static void incrementOffY() {
        offY += 0.001;
    }

    public static void onWorldRenderLast() {
        offY = 0.005;
    }

    private static RenderType makeLayer(String name, VertexFormat format, VertexFormat.Mode mode, int bufSize, boolean hasCrumbling, boolean sortOnUpload, RenderType.CompositeState glState) {
        return RenderTypeAccessor.create(name, format, mode, bufSize, hasCrumbling, sortOnUpload, glState);
    }

    private static RenderType makeLayer(String name, VertexFormat format, VertexFormat.Mode mode, int bufSize, RenderType.CompositeState glState) {
        return RenderHelper.makeLayer(name, format, mode, bufSize, false, false, glState);
    }

    private RenderHelper(String string, VertexFormat vertexFormat, VertexFormat.Mode mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
        throw new UnsupportedOperationException("Should not be instantiated");
    }

    private static RenderType getPylonGlowDirect(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, true);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, false);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture, boolean direct) {
        RenderType.CompositeState.CompositeStateBuilder glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::pylon)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY);
        if (!direct) {
            glState = glState.setOutputState(RenderStateShard.ITEM_ENTITY_TARGET);
        }
        return RenderHelper.makeLayer("botania:" + name, DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, 128, glState.createCompositeState(false));
    }

    private static RenderType.CompositeState lineState(double width, boolean direct, boolean noDepth) {
        RenderType.CompositeState.CompositeStateBuilder builder = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(width))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setWriteMaskState(noDepth ? COLOR_WRITE : COLOR_DEPTH_WRITE).setCullState(NO_CULL);
        if (!direct) {
            builder = builder.setOutputState(ITEM_ENTITY_TARGET);
        }
        if (noDepth) {
            builder = builder.setDepthTestState(NO_DEPTH_TEST);
        }
        return builder.createCompositeState(false);
    }

    public static RenderType getHaloLayer(ResourceLocation texture) {
        RenderType.CompositeState glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, true, false)).setCullState(new RenderStateShard.CullStateShard(false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(false);
        return RenderHelper.makeLayer("botania:crafting_halo", DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS, 64, false, true, glState);
    }

    public static RenderType getDopplegangerLayer(ResourceLocation texture) {
        return DOPPLEGANGER.apply(texture);
    }

    public static void drawTexturedModalRect(GuiGraphics gui, ResourceLocation textureId, int x, int y, int u, int v, int width, int height) {
        gui.blit(textureId, x, y, (float)u, (float)v, width, height, 256, 256);
    }

    public static void renderStar(PoseStack ms, MultiBufferSource buffers, int color, float xScale, float yScale, float zScale, long seed, float partialTicks) {
        VertexConsumer buffer = buffers.getBuffer(STAR);
        float semiPeriodTicks = 200.0f;
        float ticks = (float)ClientTickHandler.ticksInGame + partialTicks;
        float f1 = Mth.abs((float)Mth.sin((float)((float)Math.PI / semiPeriodTicks * ticks))) * 0.9f + 0.1f;
        float f2 = f1 > 0.0f ? (f1 - 0.7f) / 0.2f : 0.0f;
        Random random = new Random(seed);
        ms.pushPose();
        ms.scale(xScale, yScale, zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            ms.mulPose(VecHelper.rotateX(random.nextFloat() * 360.0f));
            ms.mulPose(VecHelper.rotateY(random.nextFloat() * 360.0f));
            ms.mulPose(VecHelper.rotateZ(random.nextFloat() * 360.0f));
            ms.mulPose(VecHelper.rotateX(random.nextFloat() * 360.0f));
            ms.mulPose(VecHelper.rotateY(random.nextFloat() * 360.0f));
            ms.mulPose(VecHelper.rotateZ(random.nextFloat() * 360.0f + f1 * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Matrix4f mat = ms.last().pose();
            Runnable center = () -> buffer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, f1);
            Runnable[] vertices = new Runnable[]{() -> buffer.addVertex(mat, -0.866f * f4, f3, -0.5f * f4).setColor(0, 0, 0, 0), () -> buffer.addVertex(mat, 0.866f * f4, f3, -0.5f * f4).setColor(0, 0, 0, 0), () -> buffer.addVertex(mat, 0.0f, f3, 1.0f * f4).setColor(0, 0, 0, 0), () -> buffer.addVertex(mat, -0.866f * f4, f3, -0.5f * f4).setColor(0, 0, 0, 0)};
            RenderHelper.triangleFan(center, vertices);
            ++i;
        }
        ms.popPose();
    }

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderHelper.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void flatRectangle(VertexConsumer buffer, Matrix4f mat, float xMin, float xMax, float y, float zMin, float zMax, int r, int g, int b, int a) {
        buffer.addVertex(mat, xMax, y, zMin).setColor(r, g, b, a);
        buffer.addVertex(mat, xMin, y, zMin).setColor(r, g, b, a);
        buffer.addVertex(mat, xMin, y, zMax).setColor(r, g, b, a);
        buffer.addVertex(mat, xMax, y, zMax).setColor(r, g, b, a);
    }

    public static void renderProgressPie(GuiGraphics gui, int x, int y, float progress, ItemStack stack) {
        PoseStack ms = gui.pose();
        Minecraft mc = Minecraft.getInstance();
        gui.renderItem(stack, x, y);
        RenderSystem.clear((int)256, (boolean)true);
        GL11.glEnable((int)2960);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        gui.renderItem(stack, x, y);
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        int degs = (int)(360.0f * progress);
        float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + mc.getTimer().getGameTimeDeltaPartialTick(false)) / 10.0) * 0.5f + 0.5f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        Matrix4f mat = ms.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buf.addVertex(mat, (float)centerX, (float)centerY, 0.0f).setColor(0.0f, 0.5f, 0.5f, a);
        for (int i = degs; i >= 0; --i) {
            float rad = (float)(i - 90) / 180.0f * (float)Math.PI;
            buf.addVertex(mat, (float)centerX + Mth.cos((float)rad) * (float)r, (float)centerY + Mth.sin((float)rad) * (float)r, 0.0f).setColor(0.0f, 1.0f, 0.5f, a);
        }
        buf.addVertex(mat, (float)centerX, (float)centerY, 0.0f).setColor(0.0f, 1.0f, 0.5f, a);
        Tesselator.getInstance().clear();
        RenderSystem.disableBlend();
        GL11.glDisable((int)2960);
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, PoseStack ms, MultiBufferSource buffers, int light, int overlay, @Nullable BakedModel model) {
        ms.pushPose();
        if (model == null) {
            model = Minecraft.getInstance().getItemRenderer().getModel(stack, entity.level(), entity, entity.getId());
        }
        model.getTransforms().getTransform(ItemDisplayContext.NONE).apply(false, ms);
        ms.translate(-0.5, -0.5, -0.5);
        if (model.isCustomRenderer() || stack.is(Items.TRIDENT)) {
            throw new IllegalArgumentException("Custom renderer items not supported");
        }
        RenderType rendertype = ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true);
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffers, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
        RenderHelper.renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
        ms.popPose();
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        RenderHelper.renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
    }

    private static void renderBakedItemModel(BakedModel model, ItemStack stack, int color, int light, int overlay, PoseStack ms, VertexConsumer buffer) {
        RandomSource random = RandomSource.create();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderHelper.renderBakedItemQuads(ms, buffer, color, model.getQuads(null, direction, random), stack, light, overlay);
        }
        random.setSeed(42L);
        RenderHelper.renderBakedItemQuads(ms, buffer, color, model.getQuads(null, null, random), stack, light, overlay);
    }

    private static void renderBakedItemQuads(PoseStack ms, VertexConsumer buffer, int color, List<BakedQuad> quads, ItemStack stack, int light, int overlay) {
        final float a = (float)(color >> 24 & 0xFF) / 255.0f;
        final float r = (float)(color >> 16 & 0xFF) / 255.0f;
        final float g = (float)(color >> 8 & 0xFF) / 255.0f;
        final float b = (float)(color & 0xFF) / 255.0f;
        buffer = new DelegatedVertexConsumer(buffer){

            @NotNull
            public VertexConsumer setColor(float red, float green, float blue, float alpha) {
                return super.setColor(r, g, b, a);
            }
        };
        ((ItemRendererAccessor)Minecraft.getInstance().getItemRenderer()).callRenderQuadList(ms, buffer, quads, stack, light, overlay);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, float startX, float startY, float endX, float endY, int uvStartX, int uvStartY, int uvEndX, int uvEndY, TextureAtlasSprite icon, int color, float alpha, int light) {
        Matrix4f mat = ms.last().pose();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        buffer.addVertex(mat, startX, endY, 0.0f).setColor(red, green, blue, alpha).setUv(icon.getU((float)uvStartX), icon.getV((float)uvEndY)).setLight(light);
        buffer.addVertex(mat, endX, endY, 0.0f).setColor(red, green, blue, alpha).setUv(icon.getU((float)uvEndX), icon.getV((float)uvEndY)).setLight(light);
        buffer.addVertex(mat, endX, startY, 0.0f).setColor(red, green, blue, alpha).setUv(icon.getU((float)uvEndX), icon.getV((float)uvStartY)).setLight(light);
        buffer.addVertex(mat, startX, startY, 0.0f).setColor(red, green, blue, alpha).setUv(icon.getU((float)uvStartX), icon.getV((float)uvStartY)).setLight(light);
    }

    public static void renderIconCropped(PoseStack ms, VertexConsumer buffer, int uvStartX, int uvStartY, int uvEndX, int uvEndY, TextureAtlasSprite icon, int color, float alpha, int light) {
        RenderHelper.renderIconFullBright(ms, buffer, (float)uvStartX / 16.0f, (float)uvStartY / 16.0f, (float)uvEndX / 16.0f, (float)uvEndY / 16.0f, uvStartX, uvStartY, uvEndX, uvEndY, icon, color, alpha, light);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, int color, float alpha, int light) {
        RenderHelper.renderIconCropped(ms, buffer, 0, 0, 16, 16, icon, color, alpha, light);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, int color, float alpha) {
        int fullbright = 0xF000F0;
        RenderHelper.renderIconFullBright(ms, buffer, icon, color, alpha, fullbright);
    }

    public static void renderIconFullBright(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, float alpha) {
        RenderHelper.renderIconFullBright(ms, buffer, icon, 0xFFFFFF, alpha);
    }

    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, ItemRenderer renderer) {
        RenderHelper.renderGuiItemAlpha(stack, x, y, alpha, renderer.getModel(stack, null, null, 0), renderer);
    }

    public static void renderGuiItemAlpha(ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate((float)x, (float)y, 100.0f);
        modelViewStack.translate(8.0f, 8.0f, 0.0f);
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        boolean bl = flatLight = !model.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        renderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), RenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.getBuffer(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    public static void renderHUDBox(GuiGraphics gui, int startX, int startY, int endX, int endY) {
        gui.fill(startX, startY, endX, endY, 0x44000000);
        gui.fill(startX - 2, startY - 2, endX + 2, endY + 2, 0x44000000);
    }

    public static void renderItemWithName(GuiGraphics gui, Minecraft mc, ItemStack itemStack, int startX, int startY, int color) {
        if (!itemStack.isEmpty()) {
            gui.drawString(mc.font, itemStack.getHoverName(), startX + 20, startY + 4, color);
            gui.renderItem(itemStack, startX, startY);
        }
    }

    public static void renderItemWithNameCentered(GuiGraphics gui, Minecraft mc, ItemStack itemStack, int startY, int color) {
        int centerX = mc.getWindow().getGuiScaledWidth() / 2;
        int startX = centerX - (20 + mc.font.width((FormattedText)itemStack.getHoverName())) / 2;
        RenderHelper.renderItemWithName(gui, mc, itemStack, startX, startY, color);
    }

    public static int itemWithNameWidth(Minecraft mc, ItemStack itemStack) {
        return 20 + mc.font.width((FormattedText)itemStack.getHoverName());
    }

    static {
        MANA_PYLON_GLOW = RenderHelper.getPylonGlow("mana_pylon_glow", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW = RenderHelper.getPylonGlow("natura_pylon_glow", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW = RenderHelper.getPylonGlow("gaia_pylon_glow", PylonBlockEntityRenderer.GAIA_TEXTURE);
        MANA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("mana_pylon_glow_direct", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("natura_pylon_glow_direct", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("gaia_pylon_glow_direct", PylonBlockEntityRenderer.GAIA_TEXTURE);
        ASTROLABE_PREVIEW = new AstrolabeLayer();
        offY = 0.005;
        RenderType.CompositeState glState = RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setWriteMaskState(COLOR_WRITE).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).createCompositeState(false);
        STAR = RenderHelper.makeLayer("botania:star", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES, 256, false, false, glState);
        glState = RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setCullState(NO_CULL).createCompositeState(false);
        RECTANGLE = RenderHelper.makeLayer("botania:rectangle_highlight", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, true, glState);
        CIRCLE = RenderHelper.makeLayer("botania:circle_highlight", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES, 256, false, false, glState);
        RED_STRING = RenderHelper.makeLayer("botania:red_string", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(1.0, false, false));
        LINE_1_NO_DEPTH = RenderHelper.makeLayer("botania:line_1_no_depth", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(1.0, true, true));
        LINE_4_NO_DEPTH = RenderHelper.makeLayer("botania:line_4_no_depth", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 128, RenderHelper.lineState(4.0, true, true));
        LINE_5_NO_DEPTH = RenderHelper.makeLayer("botania:line_5_no_depth", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 64, RenderHelper.lineState(5.0, true, true));
        LINE_8_NO_DEPTH = RenderHelper.makeLayer("botania:line_8_no_depth", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 64, RenderHelper.lineState(8.0, true, true));
        glState = RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).createCompositeState(true);
        SPARK = RenderHelper.makeLayer("botania:spark", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, glState);
        glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).createCompositeState(true);
        LIGHT_RELAY = RenderHelper.makeLayer("botania:light_relay", DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS, 64, glState);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).createCompositeState(true);
        ICON_OVERLAY = RenderHelper.makeLayer("botania:icon_overlay", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::manaPool)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).createCompositeState(false);
        MANA_POOL_WATER = RenderHelper.makeLayer("botania:mana_pool_water", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::terraPlate)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).createCompositeState(false);
        TERRA_PLATE = RenderHelper.makeLayer("botania:terra_plate_rune", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 128, glState);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::enchanter)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).createCompositeState(false);
        ENCHANTER = RenderHelper.makeLayer("botania:enchanter_rune", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 128, glState);
        RenderStateShard.TextureStateShard babylonTexture = new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"botania:textures/misc/babylon.png"), false, true);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)babylonTexture).setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setCullState(NO_CULL).createCompositeState(true);
        BABYLON_ICON = RenderHelper.makeLayer("botania:babylon", DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS, 64, glState);
        RenderStateShard.TextureStateShard haloTexture = new RenderStateShard.TextureStateShard(FlugelTiaraItem.textureHalo, false, true);
        glState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)haloTexture).setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::halo)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).createCompositeState(true);
        HALO = RenderHelper.makeLayer("botania:halo", DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS, 64, glState);
        glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::starfield)).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_SKY_LOCATION, false, false).add(TheEndPortalRenderer.END_PORTAL_LOCATION, false, false).build()).createCompositeState(false);
        STARFIELD = RenderHelper.makeLayer("botania:starfield", DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS, 256, false, false, glState);
        glState = RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setTransparencyState(LIGHTNING_TRANSPARENCY).createCompositeState(false);
        LIGHTNING = RenderHelper.makeLayer("botania:lightning", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, true, glState);
        TRANSLUCENT = RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        DOPPLEGANGER = Util.memoize(texture -> {
            RenderType.CompositeState glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(CoreShaders::doppleganger)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true);
            return RenderHelper.makeLayer("botania:doppleganger", DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, 256, true, true, glState);
        });
    }

    public record GhostVertexConsumer(VertexConsumer wrapped, int alpha) implements VertexConsumer
    {
        @NotNull
        public VertexConsumer addVertex(float x, float y, float z) {
            return this.wrapped.addVertex(x, y, z);
        }

        @NotNull
        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            return this.wrapped.setColor(red, green, blue, alpha * this.alpha / 255);
        }

        @NotNull
        public VertexConsumer setUv(float u, float v) {
            return this.wrapped.setUv(u, v);
        }

        @NotNull
        public VertexConsumer setUv1(int u, int v) {
            return this.wrapped.setUv1(u, v);
        }

        @NotNull
        public VertexConsumer setUv2(int u, int v) {
            return this.wrapped.setUv2(u, v);
        }

        @NotNull
        public VertexConsumer setNormal(float x, float y, float z) {
            return this.wrapped.setNormal(x, y, z);
        }
    }

    private static class AstrolabeLayer
    extends RenderType {
        public AstrolabeLayer() {
            super("botania:astrolabe", DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, 256, true, true, () -> {
                Sheets.translucentCullBlockSheet().setupRenderState();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                Sheets.translucentCullBlockSheet().clearRenderState();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
        }
    }
}

