/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.network.TriConsumer;
import vazkii.botania.xplat.BotaniaConfig;

public class CoreShaders {
    private static ShaderInstance starfieldShaderInstance;
    private static ShaderInstance doppleganger;
    private static ShaderInstance manaPool;
    private static ShaderInstance terraPlate;
    private static ShaderInstance enchanter;
    private static ShaderInstance pylon;
    private static ShaderInstance halo;
    private static ShaderInstance filmGrainParticle;
    private static ShaderInstance dopplegangerBar;

    public static void init(TriConsumer<ResourceLocation, VertexFormat, Consumer<ShaderInstance>> registrations) {
        registrations.accept(BotaniaAPI.botaniaRL("starfield"), DefaultVertexFormat.POSITION, inst -> {
            starfieldShaderInstance = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("doppleganger"), DefaultVertexFormat.NEW_ENTITY, inst -> {
            doppleganger = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("mana_pool"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, inst -> {
            manaPool = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("terra_plate_rune"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, inst -> {
            terraPlate = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("enchanter_rune"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, inst -> {
            enchanter = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("pylon"), DefaultVertexFormat.NEW_ENTITY, inst -> {
            pylon = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("halo"), DefaultVertexFormat.POSITION_TEX_COLOR, inst -> {
            halo = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("film_grain_particle"), DefaultVertexFormat.PARTICLE, inst -> {
            filmGrainParticle = inst;
        });
        registrations.accept(BotaniaAPI.botaniaRL("doppleganger_bar"), DefaultVertexFormat.POSITION_TEX, inst -> {
            dopplegangerBar = inst;
        });
    }

    public static ShaderInstance starfield() {
        return starfieldShaderInstance;
    }

    public static ShaderInstance doppleganger() {
        if (BotaniaConfig.client().useShaders()) {
            return doppleganger;
        }
        return GameRenderer.getRendertypeEntityTranslucentShader();
    }

    public static ShaderInstance manaPool() {
        if (BotaniaConfig.client().useShaders()) {
            return manaPool;
        }
        return GameRenderer.getPositionColorTexLightmapShader();
    }

    public static ShaderInstance terraPlate() {
        if (BotaniaConfig.client().useShaders()) {
            return terraPlate;
        }
        return GameRenderer.getPositionColorTexLightmapShader();
    }

    public static ShaderInstance enchanter() {
        if (BotaniaConfig.client().useShaders()) {
            return enchanter;
        }
        return GameRenderer.getPositionColorTexLightmapShader();
    }

    public static ShaderInstance pylon() {
        if (BotaniaConfig.client().useShaders()) {
            return pylon;
        }
        return GameRenderer.getRendertypeEntityTranslucentShader();
    }

    public static ShaderInstance halo() {
        if (BotaniaConfig.client().useShaders()) {
            return halo;
        }
        return GameRenderer.getPositionTexColorShader();
    }

    public static ShaderInstance filmGrainParticle() {
        if (BotaniaConfig.client().useShaders()) {
            return filmGrainParticle;
        }
        return GameRenderer.getParticleShader();
    }

    public static ShaderInstance dopplegangerBar() {
        if (BotaniaConfig.client().useShaders()) {
            return dopplegangerBar;
        }
        return GameRenderer.getPositionTexShader();
    }
}

