/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.xplat.BotaniaConfig;

public class RenderLexicon {
    private static BookModel model = null;
    private static final boolean SHOULD_MISSPELL = Math.random() < 0.004;
    public static final Material TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, BotaniaAPI.botaniaRL("item/lexicon_3d"));
    public static final Material ELVEN_TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, BotaniaAPI.botaniaRL("item/lexicon_elven_3d"));
    private static final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    private static final String[] MISSPELLINGS = new String[]{"Bonito", "Bonita", "Bonitia", "Botnaia", "Bontonio", "Botnia", "Bonitaaaaaaaaaa", "Botonio", "Botonia", "Botnetia", "Banana", "Brotania", "Botanica", "Boat", "Batania", "Bosnia"};
    private static int quote = -1;
    private static int misspelling = -1;

    private static BookModel getModel() {
        if (model == null) {
            model = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
        }
        return model;
    }

    public static boolean renderHand(ItemStack stack, ItemDisplayContext type, boolean leftHanded, PoseStack ms, MultiBufferSource buffers, int light) {
        if (!BotaniaConfig.client().lexicon3dModel() || !type.firstPerson() || stack.isEmpty() || !stack.is((Item)BotaniaItems.lexicon)) {
            return false;
        }
        try {
            RenderLexicon.doRender(stack, leftHanded, ms, buffers, light);
            return true;
        }
        catch (Throwable throwable) {
            BotaniaAPI.LOGGER.warn("Failed to render lexicon", throwable);
            return false;
        }
    }

    private static void doRender(ItemStack stack, boolean leftHanded, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.getInstance();
        ms.pushPose();
        float partialTicks = mc.getTimer().getGameTimeDeltaPartialTick(true);
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = LexicaBotaniaItem.isOpen() ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        if (!leftHanded) {
            ms.translate(0.3f + 0.02f * ticks, 0.125f + 0.01f * ticks, -0.2f - 0.035f * ticks);
            ms.mulPose(VecHelper.rotateY(180.0f + ticks * 6.0f));
        } else {
            ms.translate(0.1f - 0.02f * ticks, 0.125f + 0.01f * ticks, -0.2f - 0.035f * ticks);
            ms.mulPose(VecHelper.rotateY(200.0f + ticks * 10.0f));
        }
        ms.mulPose(VecHelper.rotateZ(-0.3f + ticks * 2.85f));
        float opening = Mth.clamp((float)(ticks / 12.0f), (float)0.0f, (float)1.0f);
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        float leftPageAngle = Mth.frac((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
        float rightPageAngle = Mth.frac((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
        BookModel model = RenderLexicon.getModel();
        model.setupAnim((float)ClientTickHandler.ticksInGame + partialTicks, Mth.clamp((float)leftPageAngle, (float)0.0f, (float)1.0f), Mth.clamp((float)rightPageAngle, (float)0.0f, (float)1.0f), opening);
        Material mat = LexicaBotaniaItem.isElven(stack) ? ELVEN_TEXTURE : TEXTURE;
        VertexConsumer buffer = mat.buffer(buffers, RenderType::entitySolid);
        model.renderToBuffer(ms, buffer, light, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        if (ticks < 3.0f) {
            Font font = Minecraft.getInstance().font;
            ms.mulPose(VecHelper.rotateZ(180.0f));
            ms.translate(-0.3f, -0.24f, -0.07f);
            ms.scale(0.003f, 0.003f, -0.003f);
            if (misspelling == -1 && mc.level != null) {
                misspelling = mc.level.random.nextInt(MISSPELLINGS.length);
            }
            String title = LexicaBotaniaItem.getTitle(stack).getString();
            if (SHOULD_MISSPELL) {
                title = title.replaceAll("Botania", MISSPELLINGS[misspelling]);
            }
            font.drawInBatch(font.plainSubstrByWidth(title, 80), 0.0f, 0.0f, 14063360, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.translate(0.0f, 10.0f, 0.0f);
            ms.scale(0.6f, 0.6f, 0.6f);
            MutableComponent edition = LexicaBotaniaItem.getEdition().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.BOLD});
            font.drawInBatch((Component)edition, 0.0f, 0.0f, 10514688, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (quote == -1 && mc.level != null) {
                quote = mc.level.random.nextInt(QUOTES.length);
            }
            String quoteStr = QUOTES[quote];
            ms.translate(-5.0f, 15.0f, 0.0f);
            RenderLexicon.renderText(0, 0, 140, 0, 7995282, quoteStr, ms.last().pose(), buffers, light);
            ms.translate(8.0f, 110.0f, 0.0f);
            String blurb = I18n.get((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]);
            font.drawInBatch(blurb, 0.0f, 0.0f, 7995282, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.translate(0.0f, 10.0f, 0.0f);
            String blurb2 = String.valueOf(ChatFormatting.UNDERLINE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]);
            font.drawInBatch(blurb2, 0.0f, 0.0f, 7995282, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.translate(0.0f, -30.0f, 0.0f);
            String authorTitle = I18n.get((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.width(authorTitle);
            font.drawInBatch(authorTitle, 58.0f - (float)len / 2.0f, -8.0f, 14063360, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
        }
        ms.popPose();
    }

    private static void renderText(int x, int y, int width, int paragraphSize, int color, String unlocalizedText, Matrix4f matrix, MultiBufferSource buffers, int light) {
        x += 2;
        y += 10;
        width -= 4;
        Font font = Minecraft.getInstance().font;
        String text = I18n.get((String)unlocalizedText, (Object[])new Object[0]).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        for (String s : textEntries) {
            String[] tokens;
            ArrayList<CallSite> words = new ArrayList<CallSite>();
            Object lineStr = "";
            for (String token : tokens = s.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = (String)lineStr + spaced;
                String controlCodes = RenderLexicon.toControlCodes(RenderLexicon.getControlCodes(prev));
                if (font.width((String)lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add((CallSite)((Object)(controlCodes + token)));
            }
            if (!((String)lineStr).isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        for (List list : lines) {
            int xi = x;
            int spacing = 4;
            for (String s : list) {
                int extra = 0;
                font.drawInBatch(s, (float)xi, (float)y, color, false, matrix, buffers, Font.DisplayMode.NORMAL, 0, light);
                xi += font.width(s) + spacing + extra;
            }
            y += list.isEmpty() ? paragraphSize : 10;
        }
    }

    private static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    private static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

