/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.block_entity.CorporeaCrystalCubeBlockEntityRenderer;
import vazkii.botania.client.render.block_entity.ManaPumpBlockEntityRenderer;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class MiscellaneousModels {
    private static final ResourceLocation goldfishModelId = BotaniaAPI.botaniaRL("icon/goldfish");
    private static final ResourceLocation phiFlowerModelId = BotaniaAPI.botaniaRL("icon/phiflower");
    private static final ResourceLocation nerfBatModelId = BotaniaAPI.botaniaRL("icon/nerfbat");
    private static final ResourceLocation bloodPendantChainId = BotaniaAPI.botaniaRL("icon/blood_pendant_chain");
    private static final ResourceLocation bloodPendantGemId = BotaniaAPI.botaniaRL("icon/blood_pendant_gem");
    private static final ResourceLocation[] kingKeyWeaponModelIds = (ResourceLocation[])IntStream.range(0, 12).mapToObj(i -> BotaniaAPI.botaniaRL("icon/gate_weapon_" + i)).toArray(ResourceLocation[]::new);
    private static final ResourceLocation terrasteelHelmWillModelId = BotaniaAPI.botaniaRL("icon/will_flame");
    private static final ResourceLocation[] thirdEyeLayerIds = (ResourceLocation[])IntStream.range(0, 3).mapToObj(i -> BotaniaAPI.botaniaRL("icon/third_eye_" + i)).toArray(ResourceLocation[]::new);
    private static final ResourceLocation pyroclastGemId = BotaniaAPI.botaniaRL("icon/lava_pendant_gem");
    private static final ResourceLocation crimsonGemId = BotaniaAPI.botaniaRL("icon/super_lava_pendant_gem");
    private static final ResourceLocation itemFinderGemId = BotaniaAPI.botaniaRL("icon/itemfinder_gem");
    private static final ResourceLocation cirrusGemId = BotaniaAPI.botaniaRL("icon/cloud_pendant_gem");
    private static final ResourceLocation nimbusGemId = BotaniaAPI.botaniaRL("icon/super_cloud_pendant_gem");
    private static final ResourceLocation snowflakePendantGemId = BotaniaAPI.botaniaRL("icon/ice_pendant_gem");
    private static final ResourceLocation[] tiaraWingIconIds = (ResourceLocation[])IntStream.range(0, 9).mapToObj(i -> BotaniaAPI.botaniaRL("icon/tiara_wing_" + (i + 1))).toArray(ResourceLocation[]::new);
    private static final ResourceLocation corporeaCrystalCubeGlassId = BotaniaAPI.botaniaRL("block/corporea_crystal_cube_glass");
    private static final ResourceLocation manaPumpHead = BotaniaAPI.botaniaRL("block/pump_head");
    private static final ResourceLocation elvenSpreaderCoreId = BotaniaAPI.botaniaRL("block/elven_spreader_core");
    private static final ResourceLocation gaiaSpreaderCoreId = BotaniaAPI.botaniaRL("block/gaia_spreader_core");
    private static final ResourceLocation manaSpreaderCoreId = BotaniaAPI.botaniaRL("block/mana_spreader_core");
    private static final ResourceLocation redstoneSpreaderCoreId = BotaniaAPI.botaniaRL("block/redstone_spreader_core");
    private static final ResourceLocation manaSpreaderScaffoldingId = BotaniaAPI.botaniaRL("block/mana_spreader_scaffolding");
    private static final ResourceLocation elvenSpreaderScaffoldingId = BotaniaAPI.botaniaRL("block/elven_spreader_scaffolding");
    private static final ResourceLocation gaiaSpreaderScaffoldingId = BotaniaAPI.botaniaRL("block/gaia_spreader_scaffolding");
    private static final Map<DyeColor, ResourceLocation> spreaderPaddingIds = new EnumMap(ColorHelper.supportedColors().collect(Collectors.toMap(Function.identity(), color -> BotaniaAPI.botaniaRL("block/" + color.getSerializedName() + "_spreader_padding"))));
    public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();
    private final Map<ResourceLocation, Function<BakedModel, BakedModel>> afterBakeModifiers;
    private final Map<ResourceLocation, Consumer<BakedModel>> modelConsumers;
    public boolean registeredModels = false;
    public final BakedModel[] tiaraWingIcons;
    public final BakedModel[] thirdEyeLayers;
    public BakedModel goldfishModel;
    public BakedModel phiFlowerModel;
    public BakedModel nerfBatModel;
    public BakedModel bloodPendantChain;
    public BakedModel bloodPendantGem;
    public BakedModel snowflakePendantGem;
    public BakedModel itemFinderGem;
    public BakedModel pyroclastGem;
    public BakedModel crimsonGem;
    public BakedModel cirrusGem;
    public BakedModel nimbusGem;
    public BakedModel terrasteelHelmWillModel;
    public BakedModel elvenSpreaderCore;
    public BakedModel gaiaSpreaderCore;
    public BakedModel manaSpreaderCore;
    public BakedModel redstoneSpreaderCore;
    public BakedModel manaSpreaderScaffolding;
    public BakedModel elvenSpreaderScaffolding;
    public BakedModel gaiaSpreaderScaffolding;
    public final HashMap<DyeColor, BakedModel> spreaderPaddings = new HashMap();
    public final BakedModel[] kingKeyWeaponModels;

    public void onModelRegister(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        this.modelConsumers.keySet().forEach(consumer);
        MiscellaneousModels.registerIslands();
        MiscellaneousModels.registerTaters(rm, consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    private static void registerIslands() {
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GRASS, BotaniaAPI.botaniaRL("block/islands/island_grass"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.PODZOL, BotaniaAPI.botaniaRL("block/islands/island_podzol"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MYCEL, BotaniaAPI.botaniaRL("block/islands/island_mycel"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SNOW, BotaniaAPI.botaniaRL("block/islands/island_snow"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.DRY, BotaniaAPI.botaniaRL("block/islands/island_dry"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GOLDEN, BotaniaAPI.botaniaRL("block/islands/island_golden"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.VIVID, BotaniaAPI.botaniaRL("block/islands/island_vivid"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SCORCHED, BotaniaAPI.botaniaRL("block/islands/island_scorched"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.INFUSED, BotaniaAPI.botaniaRL("block/islands/island_infused"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MUTATED, BotaniaAPI.botaniaRL("block/islands/island_mutated"));
    }

    private static void registerTaters(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        for (ResourceLocation model : rm.listResources("models/tiny_potato", s -> s.getPath().endsWith(".json")).keySet()) {
            if (!"botania".equals(model.getNamespace())) continue;
            String path = model.getPath();
            path = path.substring("models/".length(), path.length() - ".json".length());
            consumer.accept(BotaniaAPI.botaniaRL(path));
        }
    }

    public void onModelBake(ModelBakery loader, Map<ResourceLocation, BakedModel> map) {
        if (!this.registeredModels) {
            BotaniaAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        this.afterBakeModifiers.forEach((resourceLocation, afterBakeModifier) -> map.computeIfPresent((ResourceLocation)resourceLocation, (resourceLoc, bakedModel) -> (BakedModel)afterBakeModifier.apply(bakedModel)));
        this.modelConsumers.forEach((resourceLocation, bakedModelConsumer) -> bakedModelConsumer.accept((BakedModel)map.get(resourceLocation)));
    }

    public BakedModel modifyModelAfterbake(BakedModel bakedModel, ResourceLocation id) {
        this.modelConsumers.getOrDefault(id, model -> {}).accept(bakedModel);
        return (BakedModel)this.afterBakeModifiers.getOrDefault(id, Function.identity()).apply(bakedModel);
    }

    private MiscellaneousModels() {
        this.afterBakeModifiers = new HashMap<ResourceLocation, Function<BakedModel, BakedModel>>();
        this.afterBakeModifiers.put(BotaniaAPI.botaniaRL("abstruse_platform"), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put(BotaniaAPI.botaniaRL("spectral_platform"), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put(BotaniaAPI.botaniaRL("infrangible_platform"), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put(BotaniaAPI.botaniaRL("tiny_potato"), TinyPotatoModel::new);
        this.modelConsumers = new HashMap<ResourceLocation, Consumer<BakedModel>>();
        this.modelConsumers.put(elvenSpreaderCoreId, bakedModel -> {
            this.elvenSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(gaiaSpreaderCoreId, bakedModel -> {
            this.gaiaSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(manaSpreaderCoreId, bakedModel -> {
            this.manaSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(redstoneSpreaderCoreId, bakedModel -> {
            this.redstoneSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(manaSpreaderScaffoldingId, bakedModel -> {
            this.manaSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(elvenSpreaderScaffoldingId, bakedModel -> {
            this.elvenSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(gaiaSpreaderScaffoldingId, bakedModel -> {
            this.gaiaSpreaderScaffolding = bakedModel;
        });
        for (DyeColor color : spreaderPaddingIds.keySet()) {
            this.modelConsumers.put(spreaderPaddingIds.get(color), bakedModel -> this.spreaderPaddings.put(color, (BakedModel)bakedModel));
        }
        this.modelConsumers.put(corporeaCrystalCubeGlassId, bakedModel -> {
            CorporeaCrystalCubeBlockEntityRenderer.cubeModel = bakedModel;
        });
        this.modelConsumers.put(manaPumpHead, bakedModel -> {
            ManaPumpBlockEntityRenderer.headModel = bakedModel;
        });
        this.modelConsumers.put(goldfishModelId, bakedModel -> {
            this.goldfishModel = bakedModel;
        });
        this.modelConsumers.put(phiFlowerModelId, bakedModel -> {
            this.phiFlowerModel = bakedModel;
        });
        this.modelConsumers.put(nerfBatModelId, bakedModel -> {
            this.nerfBatModel = bakedModel;
        });
        this.modelConsumers.put(bloodPendantChainId, bakedModel -> {
            this.bloodPendantChain = bakedModel;
        });
        this.modelConsumers.put(bloodPendantGemId, bakedModel -> {
            this.bloodPendantGem = bakedModel;
        });
        this.modelConsumers.put(terrasteelHelmWillModelId, bakedModel -> {
            this.terrasteelHelmWillModel = bakedModel;
        });
        this.modelConsumers.put(pyroclastGemId, bakedModel -> {
            this.pyroclastGem = bakedModel;
        });
        this.modelConsumers.put(crimsonGemId, bakedModel -> {
            this.crimsonGem = bakedModel;
        });
        this.modelConsumers.put(itemFinderGemId, bakedModel -> {
            this.itemFinderGem = bakedModel;
        });
        this.modelConsumers.put(cirrusGemId, bakedModel -> {
            this.cirrusGem = bakedModel;
        });
        this.modelConsumers.put(nimbusGemId, bakedModel -> {
            this.nimbusGem = bakedModel;
        });
        this.modelConsumers.put(snowflakePendantGemId, bakedModel -> {
            this.snowflakePendantGem = bakedModel;
        });
        this.kingKeyWeaponModels = MiscellaneousModels.getBakedModels(this.modelConsumers, kingKeyWeaponModelIds);
        this.thirdEyeLayers = MiscellaneousModels.getBakedModels(this.modelConsumers, thirdEyeLayerIds);
        this.tiaraWingIcons = MiscellaneousModels.getBakedModels(this.modelConsumers, tiaraWingIconIds);
    }

    private static BakedModel[] getBakedModels(Map<ResourceLocation, Consumer<BakedModel>> consumers, ResourceLocation[] ids) {
        BakedModel[] bakedModels = new BakedModel[ids.length];
        int i = 0;
        while (i < ids.length) {
            int index = i++;
            consumers.put(ids[index], bakedModel -> {
                bakedModels[index] = bakedModel;
            });
        }
        return bakedModels;
    }
}

