/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.client.render.block_entity.RedStringBlockEntityRenderer;
import vazkii.botania.common.block.flower.functional.VinculotusBlockEntity;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.WandOfTheForestItem;

public final class ClientTickHandler {
    public static final int TICKS_TO_OPEN = 10;
    public static int ticksWithLexicaOpen = 0;
    public static int pageFlipTicks = 0;
    public static int ticksInGame = 0;

    private ClientTickHandler() {
    }

    public static void clientTickEnd(Minecraft mc) {
        RedStringBlockEntityRenderer.tick();
        ItemsRemainingRenderHandler.tick();
        if (mc.level == null) {
            ManaNetworkHandler.instance.clear();
            VinculotusBlockEntity.existingFlowers.clear();
        }
        if (!mc.isPaused()) {
            ++ticksInGame;
            LocalPlayer player = mc.player;
            if (player != null && PlayerHelper.hasHeldItemClass((Player)player, WandOfTheForestItem.class)) {
                for (ManaCollector collector : ImmutableList.copyOf(ManaNetworkHandler.instance.getAllCollectorsInWorld((Level)Minecraft.getInstance().level))) {
                    collector.onClientDisplayTick();
                }
            }
        }
        if (LexicaBotaniaItem.isOpen()) {
            if (ticksWithLexicaOpen < 0) {
                ticksWithLexicaOpen = 0;
            }
            if (ticksWithLexicaOpen < 10) {
                ++ticksWithLexicaOpen;
            }
            if (pageFlipTicks > 0) {
                --pageFlipTicks;
            }
        } else {
            pageFlipTicks = 0;
            if (ticksWithLexicaOpen > 0) {
                if (ticksWithLexicaOpen > 10) {
                    ticksWithLexicaOpen = 10;
                }
                --ticksWithLexicaOpen;
            }
        }
    }

    public static void notifyPageChange() {
        if (pageFlipTicks == 0) {
            pageFlipTicks = 5;
        }
    }
}

