/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.GaiaGuardianEntity;

public final class BossBarHandler {
    public static final Set<GaiaGuardianEntity> bosses = Collections.newSetFromMap(new WeakHashMap());
    private static final ResourceLocation BAR_TEXTURE = ResourceLocation.parse((String)"botania:textures/gui/boss_bar.png");

    private BossBarHandler() {
    }

    public static OptionalInt onBarRender(GuiGraphics gui, int x, int y, BossEvent bossEvent, boolean drawName) {
        for (GaiaGuardianEntity currentBoss : bosses) {
            int n;
            if (!currentBoss.getBossInfoUuid().equals(bossEvent.getId())) continue;
            Minecraft mc = Minecraft.getInstance();
            int frameU = 0;
            int frameV = 0;
            int frameWidth = 185;
            int frameHeight = 15;
            int healthU = 0;
            int healthV = frameV + frameHeight;
            int healthWidth = 181;
            int healthHeight = 7;
            int healthX = x + (frameWidth - healthWidth) / 2;
            int healthY = y + (frameHeight - healthHeight) / 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int playerCountHeight = BossBarHandler.drawPlayerCount(currentBoss.getPlayerCount(), gui, x, y);
            RenderHelper.drawTexturedModalRect(gui, BAR_TEXTURE, x, y, frameU, frameV, frameWidth, frameHeight);
            BossBarHandler.drawHealthBar(gui, currentBoss, healthX, healthY, healthU, healthV, (int)((float)healthWidth * bossEvent.getProgress()), healthHeight, false);
            if (drawName) {
                Component name = bossEvent.getName();
                int centerX = mc.getWindow().getGuiScaledWidth() / 2;
                gui.drawCenteredString(mc.font, name, centerX, y - 10, 10617228);
            }
            if (drawName) {
                Objects.requireNonNull(mc.font);
                n = 9;
            } else {
                n = 0;
            }
            return OptionalInt.of(frameHeight + playerCountHeight + n);
        }
        return OptionalInt.empty();
    }

    private static int drawPlayerCount(int playerCount, GuiGraphics gui, int x, int y) {
        PoseStack ps = gui.pose();
        ps.pushPose();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        gui.renderItem(stack, px, py);
        gui.drawString(mc.font, Integer.toString(playerCount), px + 15, py + 4, 0xFFFFFF);
        ps.popPose();
        return 5;
    }

    private static void drawHealthBar(GuiGraphics gui, GaiaGuardianEntity currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        ShaderInstance shader = CoreShaders.dopplegangerBar();
        if (shader != null) {
            float time = currentBoss.getInvulTime();
            float grainIntensity = time > 20.0f ? 1.0f : Math.max(currentBoss.isHardMode() ? 0.5f : 0.0f, time / 20.0f);
            shader.safeGetUniform("BotaniaGrainIntensity").set(grainIntensity);
            shader.safeGetUniform("BotaniaHpFract").set(currentBoss.getHealth() / currentBoss.getMaxHealth());
        }
        float minU = (float)u / 256.0f;
        float maxU = (float)(u + w) / 256.0f;
        float minV = (float)v / 256.0f;
        float maxV = (float)(v + h) / 256.0f;
        Matrix4f matrix = gui.pose().last().pose();
        RenderSystem.setShader(CoreShaders::dopplegangerBar);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + h), 0.0f).setUv(minU, maxV);
        builder.addVertex(matrix, (float)(x + w), (float)(y + h), 0.0f).setUv(maxU, maxV);
        builder.addVertex(matrix, (float)(x + w), (float)y, 0.0f).setUv(maxU, minV);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(minU, minV);
        Tesselator.getInstance().clear();
    }
}

