/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client;

import java.util.Locale;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.component.BotaniaDataComponents;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.BottledManaItem;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.LifeAggregatorItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.network.TriConsumer;

public final class BotaniaItemProperties {
    public static void init(TriConsumer<ItemLike, ResourceLocation, ClampedItemPropertyFunction> consumer) {
        consumer.accept((ItemLike)BotaniaItems.baubleBox, BotaniaAPI.botaniaRL("open"), (stack, world, entity, seed) -> stack.has(BotaniaDataComponents.ACTIVE_TRANSIENT) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.blackHoleTalisman, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> stack.has(BotaniaDataComponents.ACTIVE) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manaBottle, BotaniaAPI.botaniaRL("swigs_taken"), (stack, world, entity, seed) -> 6 - BottledManaItem.getSwigsLeft(stack));
        ResourceLocation vuvuzelaId = BotaniaAPI.botaniaRL("vuvuzela");
        ClampedItemPropertyFunction isVuvuzela = (stack, world, entity, seed) -> stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.grassHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.leavesHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.snowHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.lexicon, BotaniaAPI.botaniaRL("elven"), (stack, world, living, seed) -> LexicaBotaniaItem.isElven(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manaCookie, BotaniaAPI.botaniaRL("totalbiscuit"), (stack, world, entity, seed) -> stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.slimeBottle, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> stack.has(BotaniaDataComponents.ACTIVE_TRANSIENT) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.spawnerMover, BotaniaAPI.botaniaRL("full"), (stack, world, entity, seed) -> LifeAggregatorItem.hasData(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.temperanceStone, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> stack.has(BotaniaDataComponents.ACTIVE) ? 1.0f : 0.0f);
        ClampedItemPropertyFunction wandBindModeProperty = (stack, world, entity, seed) -> WandOfTheForestItem.getBindMode(stack) ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.twigWand, BotaniaAPI.botaniaRL("bindmode"), wandBindModeProperty);
        consumer.accept((ItemLike)BotaniaItems.dreamwoodWand, BotaniaAPI.botaniaRL("bindmode"), wandBindModeProperty);
        consumer.accept((ItemLike)BotaniaItems.autocraftingHalo, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> stack.has(BotaniaDataComponents.ACTIVE) ? 1.0f : 0.0f);
        ResourceLocation poolFullId = BotaniaAPI.botaniaRL("full");
        ClampedItemPropertyFunction poolFull = (stack, world, entity, seed) -> {
            Block block = ((BlockItem)stack.getItem()).getBlock();
            boolean renderFull = ((ManaPoolBlock)block).variant == ManaPoolBlock.Variant.CREATIVE || stack.has(BotaniaDataComponents.RENDER_FULL);
            return renderFull ? 1.0f : 0.0f;
        };
        consumer.accept((ItemLike)BotaniaBlocks.manaPool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.dilutedPool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.creativePool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.fabulousPool, poolFullId, poolFull);
        ClampedItemPropertyFunction brewGetter = (stack, world, entity, seed) -> {
            BaseBrewItem item = (BaseBrewItem)stack.getItem();
            return item.getSwigs(stack) - item.getSwigsLeft(stack);
        };
        consumer.accept((ItemLike)BotaniaItems.brewVial, BotaniaAPI.botaniaRL("swigs_taken"), brewGetter);
        consumer.accept((ItemLike)BotaniaItems.brewFlask, BotaniaAPI.botaniaRL("swigs_taken"), brewGetter);
        ResourceLocation holidayId = BotaniaAPI.botaniaRL("holiday");
        ClampedItemPropertyFunction holidayGetter = (stack, worldIn, entityIn, seed) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.manaweaveHelm, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveChest, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveBoots, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveLegs, holidayId, holidayGetter);
        ClampedItemPropertyFunction ringOnGetter = (stack, worldIn, entityIn, seed) -> {
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                if (player.getCooldowns().isOnCooldown(stack.getItem())) {
                    return 0.0f;
                }
                return 1.0f;
            }
            return 0.0f;
        };
        consumer.accept((ItemLike)BotaniaItems.magnetRing, BotaniaAPI.botaniaRL("active"), ringOnGetter);
        consumer.accept((ItemLike)BotaniaItems.magnetRingGreater, BotaniaAPI.botaniaRL("active"), ringOnGetter);
        consumer.accept((ItemLike)BotaniaItems.elementiumShears, BotaniaAPI.botaniaRL("reddit"), (stack, world, entity, seed) -> stack.getHoverName().getString().equalsIgnoreCase("dammit reddit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manasteelSword, BotaniaAPI.botaniaRL("elucidator"), (stack, world, entity, seed) -> "the elucidator".equals(stack.getHoverName().getString().toLowerCase(Locale.ROOT).trim()) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.terraAxe, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> {
            Player player;
            return !(entity instanceof Player) || TerraTruncatorItem.shouldBreak(player = (Player)entity) ? 1 : 0;
        });
        consumer.accept((ItemLike)BotaniaItems.terraPick, BotaniaAPI.botaniaRL("tipped"), (stack, world, entity, seed) -> TerraShattererItem.isTipped(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.terraPick, BotaniaAPI.botaniaRL("active"), (stack, world, entity, seed) -> TerraShattererItem.isEnabled(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.infiniteFruit, BotaniaAPI.botaniaRL("boot"), (stack, worldIn, entity, seed) -> FruitOfGrisaiaItem.isBoot(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.tornadoRod, BotaniaAPI.botaniaRL("active"), (stack, world, living, seed) -> SkiesRodItem.isFlying(stack) ? 1.0f : 0.0f);
        ClampedItemPropertyFunction pulling = (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
        ClampedItemPropertyFunction pull = (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        };
        consumer.accept((ItemLike)BotaniaItems.livingwoodBow, ResourceLocation.withDefaultNamespace((String)"pulling"), pulling);
        consumer.accept((ItemLike)BotaniaItems.livingwoodBow, ResourceLocation.withDefaultNamespace((String)"pull"), pull);
        consumer.accept((ItemLike)BotaniaItems.crystalBow, ResourceLocation.withDefaultNamespace((String)"pulling"), pulling);
        consumer.accept((ItemLike)BotaniaItems.crystalBow, ResourceLocation.withDefaultNamespace((String)"pull"), pull);
    }

    private BotaniaItemProperties() {
    }
}

