/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.state;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.CraftyCratePattern;

public final class BotaniaStateProperties {
    public static final EnumProperty<OptionalDyeColor> OPTIONAL_DYE_COLOR = EnumProperty.create((String)"color", OptionalDyeColor.class);
    public static final EnumProperty<AlfheimPortalState> ALFPORTAL_STATE = EnumProperty.create((String)"state", AlfheimPortalState.class);
    public static final EnumProperty<Direction.Axis> ENCHANTER_DIRECTION = EnumProperty.create((String)"facing", Direction.Axis.class, a -> a != Direction.Axis.Y);
    public static final EnumProperty<CraftyCratePattern> CRATE_PATTERN = EnumProperty.create((String)"pattern", CraftyCratePattern.class);
    public static final BooleanProperty HAS_LENS = BooleanProperty.create((String)"has_lens");
    public static final BooleanProperty HAS_SCAFFOLDING = BooleanProperty.create((String)"has_scaffolding");

    private BotaniaStateProperties() {
    }

    public static enum OptionalDyeColor implements StringRepresentable
    {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK,
        NONE;


        public Optional<DyeColor> toDyeColor() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Optional.of(DyeColor.WHITE);
                case 1 -> Optional.of(DyeColor.ORANGE);
                case 2 -> Optional.of(DyeColor.MAGENTA);
                case 3 -> Optional.of(DyeColor.LIGHT_BLUE);
                case 4 -> Optional.of(DyeColor.YELLOW);
                case 5 -> Optional.of(DyeColor.LIME);
                case 6 -> Optional.of(DyeColor.PINK);
                case 7 -> Optional.of(DyeColor.GRAY);
                case 8 -> Optional.of(DyeColor.LIGHT_GRAY);
                case 9 -> Optional.of(DyeColor.CYAN);
                case 10 -> Optional.of(DyeColor.PURPLE);
                case 11 -> Optional.of(DyeColor.BLUE);
                case 12 -> Optional.of(DyeColor.BROWN);
                case 13 -> Optional.of(DyeColor.GREEN);
                case 14 -> Optional.of(DyeColor.RED);
                case 15 -> Optional.of(DyeColor.BLACK);
                case 16 -> Optional.empty();
            };
        }

        public static OptionalDyeColor fromDyeColor(DyeColor color) {
            return switch (color) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> WHITE;
                case DyeColor.ORANGE -> ORANGE;
                case DyeColor.MAGENTA -> MAGENTA;
                case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
                case DyeColor.YELLOW -> YELLOW;
                case DyeColor.LIME -> LIME;
                case DyeColor.PINK -> PINK;
                case DyeColor.GRAY -> GRAY;
                case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
                case DyeColor.CYAN -> CYAN;
                case DyeColor.PURPLE -> PURPLE;
                case DyeColor.BLUE -> BLUE;
                case DyeColor.BROWN -> BROWN;
                case DyeColor.GREEN -> GREEN;
                case DyeColor.RED -> RED;
                case DyeColor.BLACK -> BLACK;
            };
        }

        public static OptionalDyeColor fromOptionalDyeColor(Optional<DyeColor> color) {
            return color.map(OptionalDyeColor::fromDyeColor).orElse(NONE);
        }

        @NotNull
        public String getSerializedName() {
            return this.toDyeColor().map(DyeColor::getSerializedName).orElse("none");
        }
    }
}

