/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block.FloatingFlowerImpl;
import vazkii.botania.api.block.FloatingFlowerProvider;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.red_string.RedStringSpooferBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.BotaniaTags;

public abstract class SpecialFlowerBlockEntity
extends BlockEntity
implements FloatingFlowerProvider {
    public static final int PODZOL_DELAY = 5;
    public static final int MYCELIUM_DELAY = 10;
    private final FloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public ItemStack getDisplayStack() {
            ResourceLocation id = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)SpecialFlowerBlockEntity.this.getType());
            return BuiltInRegistries.ITEM.getOptional(id).map(ItemStack::new).orElse(super.getDisplayStack());
        }
    };
    public int ticksExisted = 0;
    public boolean overgrowth = false;
    public boolean overgrowthBoost = false;
    @Nullable
    private BlockPos positionOverride;
    private boolean isFloating;
    public static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_FLOATING_DATA = "floating";

    public SpecialFlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, SpecialFlowerBlockEntity self) {
        BlockEntity tileBelow;
        if (self.isFloating != state.is(BotaniaTags.Blocks.FLOATING_FLOWERS)) {
            BotaniaAPI.LOGGER.error("Special flower changed floating state, this is not supported!", new Throwable());
            boolean bl = self.isFloating = !self.isFloating;
        }
        if ((tileBelow = level.getBlockEntity(worldPosition.below())) instanceof RedStringSpooferBlockEntity) {
            RedStringSpooferBlockEntity relay = (RedStringSpooferBlockEntity)tileBelow;
            BlockPos coords = relay.getBinding();
            if (coords != null) {
                self.positionOverride = coords;
                self.tickFlower();
                return;
            }
            self.positionOverride = null;
        } else {
            self.positionOverride = null;
        }
        boolean special = self.isOnSpecialSoil();
        if (special) {
            self.overgrowth = true;
            if (self.isOvergrowthAffected()) {
                self.tickFlower();
                self.overgrowthBoost = true;
            }
        }
        self.tickFlower();
        self.overgrowth = false;
        self.overgrowthBoost = false;
    }

    @Override
    @Nullable
    public FloatingFlower getFloatingData() {
        if (this.hasLevel() && this.isFloating()) {
            return this.floatingData;
        }
        return null;
    }

    public final boolean isFloating() {
        return this.isFloating;
    }

    public final void setFloating(boolean floating) {
        this.isFloating = floating;
    }

    public boolean isOnSpecialSoil() {
        if (this.isFloating()) {
            return false;
        }
        return this.level.getBlockState(this.worldPosition.below()).is(BotaniaBlocks.enchantedSoil);
    }

    public final BlockPos getEffectivePos() {
        return this.positionOverride != null ? this.positionOverride : this.getBlockPos();
    }

    protected void tickFlower() {
        ++this.ticksExisted;
    }

    public final void loadAdditional(CompoundTag cmp, HolderLookup.Provider registries) {
        super.loadAdditional(cmp, registries);
        if (cmp.contains(TAG_TICKS_EXISTED)) {
            this.ticksExisted = cmp.getInt(TAG_TICKS_EXISTED);
        }
        if (this.getBlockState().getBlock() instanceof FloatingFlowerBlock) {
            this.setFloating(true);
        }
        FloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        this.readFromPacketNBT(cmp, registries);
        if (this.isFloating() && oldType != this.floatingData.getIslandType() && this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public final void saveAdditional(CompoundTag cmp, HolderLookup.Provider registries) {
        super.saveAdditional(cmp, registries);
        cmp.putInt(TAG_TICKS_EXISTED, this.ticksExisted);
        this.writeToPacketNBT(cmp, registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.writeToPacketNBT(tag, registries);
        return tag;
    }

    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        if (this.isFloating()) {
            cmp.put(TAG_FLOATING_DATA, this.floatingData.writeNBT());
        }
    }

    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        if (cmp.contains(TAG_FLOATING_DATA)) {
            this.floatingData.readNBT(cmp.getCompound(TAG_FLOATING_DATA));
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    @Nullable
    public abstract RadiusDescriptor getRadius();

    @Nullable
    public RadiusDescriptor getSecondaryRadius() {
        return null;
    }

    public boolean isOvergrowthAffected() {
        return true;
    }

    public int getComparatorSignal() {
        return 0;
    }

    public int getModulatedDelay() {
        if (this.isFloating()) {
            FloatingFlower.IslandType type = this.floatingData.getIslandType();
            if (type == FloatingFlower.IslandType.MYCEL) {
                return 10;
            }
            if (type == FloatingFlower.IslandType.PODZOL) {
                return 5;
            }
        } else {
            BlockState below = this.level.getBlockState(this.getBlockPos().below());
            if (below.is(Blocks.MYCELIUM)) {
                return 10;
            }
            if (below.is(Blocks.PODZOL)) {
                return 5;
            }
        }
        return 0;
    }

    @Nullable
    public Object getRenderData() {
        if (this.isFloating()) {
            return this.floatingData.getIslandType();
        }
        return null;
    }

    public void emitParticle(ParticleOptions options, double xOffset, double yOffset, double zOffset, double xSpeed, double ySpeed, double zSpeed) {
        if (!this.level.isClientSide) {
            return;
        }
        Vec3 offset = this.level.getBlockState(this.getEffectivePos()).getOffset((BlockGetter)this.level, this.getEffectivePos());
        this.level.addParticle(options, (double)this.getEffectivePos().getX() + offset.x + xOffset, (double)this.getEffectivePos().getY() + offset.y + yOffset, (double)this.getEffectivePos().getZ() + offset.z + zOffset, xSpeed, ySpeed, zSpeed);
    }
}

