/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaCollector;

public abstract class GeneratingFlowerBlockEntity
extends BindableSpecialFlowerBlockEntity<ManaCollector> {
    private static final ResourceLocation SPREADER_ID = BotaniaAPI.botaniaRL("mana_spreader");
    public static final int LINK_RANGE = 6;
    private static final String TAG_MANA = "mana";
    private int mana;

    public GeneratingFlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ManaCollector.class);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            double particleChance = 1.0 - (double)this.getMana() / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                Vec3 offset = this.getLevel().getBlockState(this.getBlockPos()).getOffset((BlockGetter)this.getLevel(), this.getBlockPos());
                double x = (double)this.getBlockPos().getX() + offset.x;
                double y = (double)this.getBlockPos().getY() + offset.y;
                double z = (double)this.getBlockPos().getZ() + offset.z;
                BotaniaAPI.instance().sparkleFX(this.getLevel(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
        this.emptyManaIntoCollector();
    }

    @Override
    public int getBindingRadius() {
        return 6;
    }

    @Override
    @Nullable
    public BlockPos findClosestTarget() {
        ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        ManaCollector closestCollector = network.getClosestCollector(this.getBlockPos(), this.getLevel(), this.getBindingRadius());
        return closestCollector == null ? null : closestCollector.getManaReceiverPos();
    }

    public void emptyManaIntoCollector() {
        ManaCollector collector = (ManaCollector)this.findBoundTile();
        if (collector != null && !collector.isFull() && this.getMana() > 0) {
            int manaval = Math.min(this.getMana(), collector.getMaxMana() - collector.getCurrentMana());
            this.addMana(-manaval);
            collector.receiveMana(manaval);
            this.sync();
        }
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.getMana() + mana);
        this.setChanged();
    }

    @Override
    public ItemStack getDefaultHudIcon() {
        return BuiltInRegistries.ITEM.getOptional(SPREADER_ID).map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.mana = cmp.getInt(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_MANA, this.getMana());
    }
}

