/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.block.PhantomInkableBlock;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.fx.BotaniaParticles;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.PlayerAccess;
import vazkii.botania.common.advancements.BotaniaCriteriaTriggers;
import vazkii.botania.common.block.BotaniaBannerPatterns;
import vazkii.botania.common.block.BotaniaBlockFlammability;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.ManastormChargeBlock;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BlockEntityConstants;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CraftyCrateBlockEntity;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.PowerGeneratorBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.block.flower.functional.DaffomillBlockEntity;
import vazkii.botania.common.block.flower.functional.LooniumBlockEntity;
import vazkii.botania.common.block.flower.functional.TigerseyeBlockEntity;
import vazkii.botania.common.block.flower.functional.VinculotusBlockEntity;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaDetectorBlock;
import vazkii.botania.common.block.mana.ManaVoidBlock;
import vazkii.botania.common.block.red_string.RedStringInterceptorBlock;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.brew.effect.SoulCrossMobEffect;
import vazkii.botania.common.command.SkyblockCommand;
import vazkii.botania.common.config.ConfigDataManagerImpl;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.CommonTickHandler;
import vazkii.botania.common.handler.CompostingData;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.handler.PaintableData;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.handler.SleepingHandler;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.DefaultHornHarvestable;
import vazkii.botania.common.impl.corporea.DefaultCorporeaMatchers;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.EnderHandItem;
import vazkii.botania.common.item.FlowerPouchItem;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.ManaMirrorItem;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.item.ResoluteIvyItem;
import vazkii.botania.common.item.SpellbindingClothItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelHelmItem;
import vazkii.botania.common.item.equipment.bauble.BandOfManaItem;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.equipment.bauble.BenevolentGoddessCharmItem;
import vazkii.botania.common.item.equipment.bauble.CharmOfTheDivaItem;
import vazkii.botania.common.item.equipment.bauble.CloakOfVirtueItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.GreaterBandOfManaItem;
import vazkii.botania.common.item.equipment.bauble.RingOfMagnetizationItem;
import vazkii.botania.common.item.equipment.bauble.SojournersSashItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.material.EnderAirItem;
import vazkii.botania.common.item.relic.DiceOfFateItem;
import vazkii.botania.common.item.relic.EyeOfTheFlugelItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;
import vazkii.botania.common.item.relic.RingOfLokiItem;
import vazkii.botania.common.item.relic.RingOfOdinItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.item.rod.BifrostRodItem;
import vazkii.botania.common.item.rod.DepthsRodItem;
import vazkii.botania.common.item.rod.HellsRodItem;
import vazkii.botania.common.item.rod.LandsRodItem;
import vazkii.botania.common.item.rod.PlentifulMantleRodItem;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.common.item.rod.TerraFirmaRodItem;
import vazkii.botania.common.item.rod.UnstableReservoirRodItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootModifiers;
import vazkii.botania.common.loot.LootHandler;
import vazkii.botania.common.world.BotaniaFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.ForgeBotaniaConfig;
import vazkii.botania.forge.integration.InventorySorterIntegration;
import vazkii.botania.forge.integration.corporea.ForgeCapCorporeaNodeDetector;
import vazkii.botania.forge.integration.curios.CurioIntegration;
import vazkii.botania.forge.internal_caps.RedStringContainerCapProvider;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.forge.xplat.ForgeXplatImpl;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="botania")
public class ForgeCommonInitializer {
    private final Set<Item> itemsToAddToCreativeTab = new LinkedHashSet<Item>();
    private static final Supplier<Map<Item, Function<ItemStack, AvatarWieldable>>> AVATAR_WIELDABLES = Suppliers.memoize(() -> Map.of(BotaniaItems.dirtRod, s -> new LandsRodItem.AvatarBehavior(), BotaniaItems.diviningRod, s -> new PlentifulMantleRodItem.AvatarBehavior(), BotaniaItems.fireRod, s -> new HellsRodItem.AvatarBehavior(), BotaniaItems.missileRod, s -> new UnstableReservoirRodItem.AvatarBehavior(), BotaniaItems.rainbowRod, s -> new BifrostRodItem.AvatarBehavior(), BotaniaItems.tornadoRod, s -> new SkiesRodItem.AvatarBehavior()));
    private static final Supplier<Map<Item, Function<ItemStack, BlockProvider>>> BLOCK_PROVIDER = Suppliers.memoize(() -> Map.of(BotaniaItems.dirtRod, LandsRodItem.BlockProviderImpl::new, BotaniaItems.skyDirtRod, LandsRodItem.BlockProviderImpl::new, BotaniaItems.blackHoleTalisman, BlackHoleTalismanItem.BlockProviderImpl::new, BotaniaItems.cobbleRod, s -> new DepthsRodItem.BlockProviderImpl(), BotaniaItems.enderHand, EnderHandItem.BlockProviderImpl::new, BotaniaItems.terraformRod, s -> new TerraFirmaRodItem.BlockProviderImpl()));
    private static final Supplier<Map<Item, Function<ItemStack, CoordBoundItem>>> COORD_BOUND_ITEM = Suppliers.memoize(() -> Map.of(BotaniaItems.flugelEye, EyeOfTheFlugelItem.CoordBoundItemImpl::new, BotaniaItems.manaMirror, ManaMirrorItem.CoordBoundItemImpl::new, BotaniaItems.twigWand, WandOfTheForestItem.CoordBoundItemImpl::new, BotaniaItems.dreamwoodWand, WandOfTheForestItem.CoordBoundItemImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, ManaItem>>> MANA_ITEM = Suppliers.memoize(() -> Map.of(BotaniaItems.manaMirror, ManaMirrorItem.ManaItemImpl::new, BotaniaItems.manaRing, BandOfManaItem.ManaItemImpl::new, BotaniaItems.manaRingGreater, GreaterBandOfManaItem.GreaterManaItemImpl::new, BotaniaItems.manaTablet, ManaTabletItem.ManaItemImpl::new, BotaniaItems.terraPick, TerraShattererItem.ManaItemImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, Relic>>> RELIC = Suppliers.memoize(() -> Map.of(BotaniaItems.dice, DiceOfFateItem::makeRelic, BotaniaItems.flugelEye, EyeOfTheFlugelItem::makeRelic, BotaniaItems.infiniteFruit, FruitOfGrisaiaItem::makeRelic, BotaniaItems.kingKey, KeyOfTheKingsLawItem::makeRelic, BotaniaItems.lokiRing, RingOfLokiItem::makeRelic, BotaniaItems.odinRing, RingOfOdinItem::makeRelic, BotaniaItems.thorRing, RingOfThorItem::makeRelic));

    public ForgeCommonInitializer() {
        this.coreInit();
        this.registryInit();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        ForgePacketHandler.init();
        this.registerEvents();
        evt.enqueueWork(BotaniaBlocks::addDispenserBehaviours);
        evt.enqueueWork(() -> {
            BiConsumer<ResourceLocation, Supplier<? extends Block>> consumer = (resourceLocation, blockSupplier) -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(resourceLocation, blockSupplier);
            BotaniaBlocks.registerFlowerPotPlants(consumer);
            BotaniaFlowerBlocks.registerFlowerPotPlants(consumer);
        });
        BotaniaBlocks.addAxeStripping();
        PaintableData.init();
        CompostingData.init((itemLike, chance) -> ComposterBlock.COMPOSTABLES.putIfAbsent((Object)itemLike.asItem(), chance.floatValue()));
        DefaultCorporeaMatchers.init();
        PlayerHelper.setFakePlayerClass(FakePlayer.class);
        PatchouliAPI.get().registerMultiblock(BuiltInRegistries.BLOCK.getKey((Object)BotaniaBlocks.alfPortal), AlfheimPortalBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(BuiltInRegistries.BLOCK.getKey((Object)BotaniaBlocks.terraPlate), TerrestrialAgglomerationPlateBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(BuiltInRegistries.BLOCK.getKey((Object)BotaniaBlocks.enchanter), ManaEnchanterBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), GaiaGuardianEntity.ARENA_MULTIBLOCK.get());
        OrechidManager.registerListener();
        ConfigDataManagerImpl.registerListener();
        CraftyCrateBlockEntity.registerListener();
        CorporeaNodeDetectors.register(new ForgeCapCorporeaNodeDetector());
        if (ModList.get().isLoaded("inventorysorter")) {
            InventorySorterIntegration.init();
        }
    }

    private void coreInit() {
        BotaniaAPI.LOGGER.debug("API instances: {}", List.of(BotaniaAPI.instance(), XplatAbstractions.instance(), CorporeaHelper.instance(), ManaItemHandler.instance()));
        ForgeBotaniaConfig.setup();
        EquipmentHandler.init();
    }

    private void registryInit() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeCommonInitializer.bind(Registries.SOUND_EVENT, BotaniaSounds::init);
        ForgeCommonInitializer.bind(Registries.BLOCK, consumer -> {
            BotaniaBlocks.registerBlocks(consumer);
            BotaniaBlockFlammability.register();
        });
        this.bindForItems(BotaniaBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(Registries.BLOCK_ENTITY_TYPE, BotaniaBlockEntities::registerTiles);
        this.bindForItems(BotaniaItems::registerItems);
        ForgeCommonInitializer.bind(Registries.BLOCK, BotaniaFlowerBlocks::registerBlocks);
        this.bindForItems(BotaniaFlowerBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(Registries.BLOCK_ENTITY_TYPE, BotaniaFlowerBlocks::registerTEs);
        ForgeCommonInitializer.bind(Registries.MENU, BotaniaItems::registerMenuTypes);
        ForgeCommonInitializer.bind(Registries.RECIPE_SERIALIZER, BotaniaItems::registerRecipeSerializers);
        ForgeCommonInitializer.bind(Registries.BANNER_PATTERN, BotaniaBannerPatterns::submitRegistrations);
        ForgeCommonInitializer.bind(Registries.RECIPE_TYPE, BotaniaRecipeTypes::submitRecipeTypes);
        ForgeCommonInitializer.bind(Registries.RECIPE_SERIALIZER, BotaniaRecipeTypes::submitRecipeSerializers);
        ForgeCommonInitializer.bind(Registries.ENTITY_TYPE, BotaniaEntities::registerEntities);
        modBus.addListener(e -> BotaniaEntities.registerAttributes((type, builder) -> e.put(type, builder.build())));
        modBus.addListener(e -> e.add(EntityType.PLAYER, PixieHandler.PIXIE_SPAWN_CHANCE));
        ForgeCommonInitializer.bind(Registries.ATTRIBUTE, PixieHandler::registerAttribute);
        ForgeCommonInitializer.bind(Registries.MOB_EFFECT, BotaniaMobEffects::registerPotions);
        ForgeCommonInitializer.bind(BotaniaRegistries.BREWS, BotaniaBrews::submitRegistrations);
        ForgeCommonInitializer.bind(Registries.FEATURE, BotaniaFeatures::registerFeatures);
        ForgeCommonInitializer.bind(Registries.CHUNK_GENERATOR, SkyblockChunkGenerator::submitRegistration);
        BotaniaCriteriaTriggers.init();
        ForgeCommonInitializer.bind(Registries.PARTICLE_TYPE, BotaniaParticles::registerParticles);
        ForgeCommonInitializer.bind(Registries.LOOT_CONDITION_TYPE, BotaniaLootModifiers::submitLootConditions);
        ForgeCommonInitializer.bind(Registries.LOOT_FUNCTION_TYPE, BotaniaLootModifiers::submitLootFunctions);
        modBus.addListener(evt -> {
            if (evt.getRegistryKey().equals((Object)Registries.CUSTOM_STAT)) {
                BotaniaStats.init();
            }
        });
        ForgeCommonInitializer.bind(Registries.CREATIVE_MODE_TAB, consumer -> consumer.accept(CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.botania").withStyle(style -> style.withColor(ChatFormatting.WHITE))).icon(() -> new ItemStack((ItemLike)BotaniaItems.lexicon)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).backgroundSuffix("botania.png").withSearchBar().build(), BotaniaRegistries.BOTANIA_TAB_KEY.location()));
        modBus.addListener(e -> {
            if (e.getTabKey() == BotaniaRegistries.BOTANIA_TAB_KEY) {
                for (Item item : this.itemsToAddToCreativeTab) {
                    BlockItem bi;
                    Block patt12466$temp;
                    if (item instanceof CustomCreativeTabContents) {
                        CustomCreativeTabContents cc = (CustomCreativeTabContents)item;
                        cc.addToCreativeTab(item, (CreativeModeTab.Output)e);
                        continue;
                    }
                    if (item instanceof BlockItem && (patt12466$temp = (bi = (BlockItem)item).getBlock()) instanceof CustomCreativeTabContents) {
                        CustomCreativeTabContents cc = (CustomCreativeTabContents)patt12466$temp;
                        cc.addToCreativeTab(item, (CreativeModeTab.Output)e);
                        continue;
                    }
                    e.accept((ItemLike)item);
                }
            }
        });
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private void bindForItems(Consumer<BiConsumer<Item, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.ITEM)) {
                source.accept((t, rl) -> {
                    this.itemsToAddToCreativeTab.add((Item)t);
                    event.register(Registries.ITEM, rl, () -> t);
                });
            }
        });
    }

    private void registerEvents() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        this.registerBlockLookasides();
        bus.addGenericListener(ItemStack.class, this::attachItemCaps);
        bus.addGenericListener(BlockEntity.class, this::attachBeCaps);
        int blazeTime = 2400 * (XplatAbstractions.INSTANCE.gogLoaded() ? 5 : 10);
        bus.addListener(e -> {
            if (e.getItemStack().is(BotaniaBlocks.blazeBlock.asItem())) {
                e.setBurnTime(blazeTime);
            }
        });
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            bus.addListener(e -> {
                InteractionResult result = SkyblockWorldEvents.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result == InteractionResult.SUCCESS) {
                    e.setCanceled(true);
                    e.setCancellationResult(InteractionResult.SUCCESS);
                }
            });
        }
        bus.addListener(e -> ((ShiftingCrustRodItem)BotaniaItems.exchangeRod).onLeftClick(e.getEntity(), e.getLevel(), e.getHand(), e.getPos(), e.getFace()));
        bus.addListener(e -> TerraBladeItem.leftClick(e.getItemStack()));
        bus.addListener(e -> TerraBladeItem.attackEntity(e.getEntity(), e.getEntity().level(), InteractionHand.MAIN_HAND, e.getTarget(), null));
        bus.addListener(e -> this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getCommandSelection() == Commands.CommandSelection.DEDICATED));
        bus.addListener(e -> {
            Player.BedSleepingProblem problem = SleepingHandler.trySleep(e.getEntity(), e.getPos());
            if (problem != null) {
                e.setResult(problem);
            }
        });
        bus.addListener(e -> DaffomillBlockEntity.onItemTrack((Entity)e.getEntity(), (ServerPlayer)e.getEntity()));
        bus.addListener(e -> LootHandler.lootLoad(e.getName(), b -> e.getTable().addPool(b.build())));
        bus.addListener(e -> ManaNetworkHandler.instance.onNetworkEvent(e.getReceiver(), e.getType(), e.getAction()));
        bus.addListener(e -> {
            if (!e.getLevel().isClientSide) {
                TigerseyeBlockEntity.pacifyAfterLoad(e.getEntity(), (ServerLevel)e.getLevel());
            }
        });
        bus.addListener(e -> this.serverAboutToStart(e.getServer()));
        bus.addListener(e -> this.serverStopping(e.getServer()));
        bus.addListener(e -> FlugelTiaraItem.playerLoggedOut((ServerPlayer)e.getEntity()));
        bus.addListener(e -> ResoluteIvyItem.onPlayerRespawn(e.getOriginal(), e.getEntity(), !e.isWasDeath()));
        bus.addListener(e -> {
            Level patt16163$temp;
            if (e.phase == TickEvent.Phase.END && (patt16163$temp = e.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt16163$temp;
                CommonTickHandler.onTick(level);
                GrassSeedsItem.onTickEnd(level);
                TerraTruncatorItem.onTickEnd(level);
            }
        });
        bus.addListener(e -> {
            RedStringInterceptorBlock.onInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            RingOfLokiItem.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
        });
        bus.addListener(e -> {
            InteractionResultHolder<ItemStack> result = EnderAirItem.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand());
            if (result.getResult().consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result.getResult());
            }
        });
        bus.addListener(e -> {
            if (SpellbindingClothItem.shouldDenyAnvil(e.getLeft(), e.getRight())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            BlockState input;
            Block output;
            if (e.getToolAction() == ToolActions.AXE_STRIP && (output = ForgeXplatImpl.CUSTOM_STRIPPABLES.get((input = e.getState()).getBlock())) != null) {
                e.setFinalState(output.withPropertiesOf(input));
            }
        });
        bus.addListener(e -> {
            EnderMan em;
            Vec3 newPos;
            LivingEntity patt17631$temp = e.getEntityLiving();
            if (patt17631$temp instanceof EnderMan && (newPos = VinculotusBlockEntity.onEndermanTeleport(em = (EnderMan)patt17631$temp, e.getTargetX(), e.getTargetY(), e.getTargetZ())) != null) {
                e.setTargetX(newPos.x());
                e.setTargetY(newPos.y());
                e.setTargetZ(newPos.z());
            }
        });
        bus.addListener(e -> {
            if (BenevolentGoddessCharmItem.shouldProtectExplosion(e.getLevel(), e.getExplosion().getPosition())) {
                e.getExplosion().clearToBlow();
            }
        });
        bus.addListener(e -> {
            if (FlowerPouchItem.onPickupItem(e.getItem(), e.getEntity())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            LivingEntity living = e.getEntity();
            LooniumBlockEntity.dropLooniumItems(living, stack -> {
                e.getDrops().clear();
                if (!stack.isEmpty()) {
                    ItemEntity ent = new ItemEntity(living.level(), living.getX(), living.getY(), living.getZ(), stack);
                    ent.setDefaultPickUpDelay();
                    e.getDrops().add(ent);
                }
            });
        });
        bus.addListener(e -> {
            Entity patt18803$temp = e.getSource().getEntity();
            if (patt18803$temp instanceof LivingEntity) {
                LivingEntity killer = (LivingEntity)patt18803$temp;
                SoulCrossMobEffect.onEntityKill(e.getEntity(), killer);
            }
        });
        bus.addListener(e -> SojournersSashItem.onPlayerJump(e.getEntity()));
        bus.addListener(e -> {
            Player player;
            LivingEntity patt19113$temp = e.getEntity();
            if (patt19113$temp instanceof Player && RingOfOdinItem.onPlayerAttacked(player = (Player)patt19113$temp, e.getSource())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> RingOfMagnetizationItem.onTossItem(e.getPlayer()));
        bus.addListener(e -> {
            Entity patt19849$temp;
            Player player;
            LivingEntity patt19402$temp = e.getEntity();
            if (patt19402$temp instanceof Player) {
                player = (Player)patt19402$temp;
                Container worn = EquipmentHandler.getAllWorn((LivingEntity)player);
                for (int i = 0; i < worn.getContainerSize(); ++i) {
                    ItemStack stack = worn.getItem(i);
                    Item patt19613$temp = stack.getItem();
                    if (!(patt19613$temp instanceof CloakOfVirtueItem)) continue;
                    CloakOfVirtueItem cloak = (CloakOfVirtueItem)patt19613$temp;
                    e.setAmount(cloak.onPlayerDamage(player, e.getSource(), e.getAmount()));
                }
                PixieHandler.onDamageTaken(player, e.getSource());
            }
            if ((patt19849$temp = e.getSource().getDirectEntity()) instanceof Player) {
                player = (Player)patt19849$temp;
                CharmOfTheDivaItem.onEntityDamaged(player, e.getEntity());
            }
        });
        bus.addListener(e -> {
            LivingEntity patt20032$temp = e.getEntity();
            if (patt20032$temp instanceof Player) {
                Player player = (Player)patt20032$temp;
                FlugelTiaraItem.updatePlayerFlyStatus(player);
                SojournersSashItem.tickBelt(player);
            }
        });
        bus.addListener(e -> {
            LivingEntity patt20233$temp = e.getEntity();
            if (patt20233$temp instanceof Player) {
                Player player = (Player)patt20233$temp;
                e.setDistance(SojournersSashItem.onPlayerFall(player, e.getDistance()));
            }
        });
        bus.addListener(EventPriority.LOW, e -> {
            Entity patt20689$temp;
            Event.Result result = e.getResult();
            if (e.getEntity().level().isClientSide || result == Event.Result.DENY || result == Event.Result.DEFAULT && !e.isVanillaCritical() || !TerrasteelHelmItem.hasTerraArmorSet(e.getEntity()) || !((patt20689$temp = e.getTarget()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)patt20689$temp;
            e.setDamageModifier(e.getDamageModifier() * TerrasteelHelmItem.getCritDamageMult(e.getEntity()));
            ((PlayerAccess)e.getEntity()).botania$setCritTarget(target);
        });
        bus.addListener(e -> AssemblyHaloItem.onItemCrafted(e.getEntity(), e.getInventory()));
    }

    private void attachItemCaps(AttachCapabilitiesEvent<ItemStack> e) {
        Function<ItemStack, Relic> makeRelic;
        Function<ItemStack, ManaItem> makeManaItem;
        Function<ItemStack, CoordBoundItem> makeCoordBoundItem;
        Function<ItemStack, BlockProvider> makeBlockProvider;
        Function<ItemStack, AvatarWieldable> makeAvatarWieldable;
        EquipmentHandler equipmentHandler;
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.getItem() instanceof BaubleItem && (equipmentHandler = EquipmentHandler.instance) instanceof CurioIntegration) {
            CurioIntegration ci = (CurioIntegration)equipmentHandler;
            e.addCapability(ResourceLocationHelper.prefix("curio"), ci.initCapability(stack));
        }
        if (stack.is(BotaniaItems.waterBowl)) {
            e.addCapability(ResourceLocationHelper.prefix("water_bowl"), (ICapabilityProvider)new CapabilityUtil.WaterBowlFluidHandler(stack));
        }
        if (stack.is(BotaniaItems.openBucket)) {
            e.addCapability(ResourceLocationHelper.prefix("open_bucket"), (ICapabilityProvider)new CapabilityUtil.ExtrapolatedBucketFluidHandler(stack));
        }
        if ((makeAvatarWieldable = AVATAR_WIELDABLES.get().get(stack.getItem())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("avatar_wieldable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.AVATAR_WIELDABLE, makeAvatarWieldable.apply(stack)));
        }
        if ((makeBlockProvider = BLOCK_PROVIDER.get().get(stack.getItem())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("block_provider"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.BLOCK_PROVIDER, makeBlockProvider.apply(stack)));
        }
        if ((makeCoordBoundItem = COORD_BOUND_ITEM.get().get(stack.getItem())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("coord_bound_item"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.COORD_BOUND_ITEM, makeCoordBoundItem.apply(stack)));
        }
        if ((makeManaItem = MANA_ITEM.get().get(stack.getItem())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("mana_item"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_ITEM, makeManaItem.apply(stack)));
        }
        if ((makeRelic = RELIC.get().get(stack.getItem())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("relic"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.RELIC, makeRelic.apply(stack)));
        }
    }

    private void registerBlockLookasides() {
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> (world, pos, stack, hornType, living) -> hornType == HornHarvestable.EnumHornType.CANOPY, Blocks.VINE, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, Blocks.TWISTING_VINES, Blocks.TWISTING_VINES_PLANT, Blocks.WEEPING_VINES, Blocks.WEEPING_VINES_PLANT);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getMushroom).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getShinyFlower).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_GHOST, (w, p, s) -> (ManaCollisionGhost)s.getBlock(), BotaniaBlocks.manaDetector, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.infrangiblePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.prism, BotaniaBlocks.tinyPlanet);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_RECEIVER, ManaVoidBlock.ManaReceiverImpl::new, BotaniaBlocks.manaVoid);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, DrumBlock.ManaTriggerImpl::new, BotaniaBlocks.canopyDrum, BotaniaBlocks.wildDrum, BotaniaBlocks.gatheringDrum);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, ManastormChargeBlock.ManaTriggerImpl::new, BotaniaBlocks.manaBomb);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, ManaDetectorBlock.ManaTriggerImpl::new, BotaniaBlocks.manaDetector);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.WANDABLE, (world, pos, state) -> (player, stack, side) -> ((ForceRelayBlock)state.getBlock()).onUsedByWand(player, stack, world, pos), BotaniaBlocks.pistonRelay);
    }

    private void attachBeCaps(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        if (be instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("exoflame_heatable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.EXOFLAME_HEATABLE, new ExoflameFurnaceHandler.FurnaceExoflameHeatable(furnace)));
        }
        if (be instanceof ExposedSimpleInventoryBlockEntity) {
            ExposedSimpleInventoryBlockEntity inv = (ExposedSimpleInventoryBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("inv"), CapabilityUtil.makeProvider(ForgeCapabilities.ITEM_HANDLER, new SidedInvWrapper((WorldlyContainer)inv, null)));
        }
        if (be instanceof PowerGeneratorBlockEntity) {
            final PowerGeneratorBlockEntity gen = (PowerGeneratorBlockEntity)be;
            IEnergyStorage energyStorage = new IEnergyStorage(){

                public int getEnergyStored() {
                    return gen.getEnergy();
                }

                public int getMaxEnergyStored() {
                    return PowerGeneratorBlockEntity.MAX_ENERGY;
                }

                public boolean canExtract() {
                    return false;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public boolean canReceive() {
                    return false;
                }
            };
            e.addCapability(ResourceLocationHelper.prefix("fe"), CapabilityUtil.makeProvider(ForgeCapabilities.ENERGY, energyStorage));
        }
        if (be.getType() == BotaniaBlockEntities.ANIMATED_TORCH) {
            e.addCapability(ResourceLocationHelper.prefix("hourglass_trigger"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.HOURGLASS_TRIGGER, hourglass -> ((AnimatedTorchBlockEntity)be).toggle()));
        }
        if (BlockEntityConstants.SELF_WANDADBLE_BES.contains(be.getType())) {
            e.addCapability(ResourceLocationHelper.prefix("wandable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.WANDABLE, (Wandable)be));
        }
        if (BlockEntityConstants.SELF_PHANTOM_INKABLE_BES.contains(be.getType())) {
            e.addCapability(ResourceLocationHelper.prefix("phantom_inkable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.PHANTOM_INKABLE, (PhantomInkableBlock)be));
        }
        if (be instanceof RedStringContainerBlockEntity) {
            RedStringContainerBlockEntity container = (RedStringContainerBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("red_string"), (ICapabilityProvider)new RedStringContainerCapProvider(container));
        }
        if (BlockEntityConstants.SELF_MANA_TRIGGER_BES.contains(be.getType())) {
            e.addCapability(ResourceLocationHelper.prefix("mana_trigger"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_TRIGGER, (ManaTrigger)be));
        }
        if (BlockEntityConstants.SELF_MANA_RECEIVER_BES.contains(be.getType())) {
            e.addCapability(ResourceLocationHelper.prefix("mana_receiver"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_RECEIVER, (ManaReceiver)be));
        }
        if (BlockEntityConstants.SELF_SPARK_ATTACHABLE_BES.contains(be.getType())) {
            e.addCapability(ResourceLocationHelper.prefix("spark_attachable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.SPARK_ATTACHABLE, (SparkAttachable)be));
        }
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.isDedicatedServer()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockCommand.register(dispatcher);
        }
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        CorporeaIndexBlockEntity.clearIndexCache();
    }
}

