/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.loot.BotaniaLootTables;

public class LooniumEquipmentLootProvider
implements DataProvider {
    public static final int COLOR_ENDERMAN_BODY = 0x1D1D21;
    public static final int COLOR_TIDE_LEATHER = 1481884;
    public static final int COLOR_EVOKER_COAT = 3290681;
    public static final int COLOR_VINDICATOR_BOOTS = 3290681;
    public static final int COLOR_VINDICATOR_JACKET = 4673362;
    public static final int COLOR_VINDICATOR_LEGWEAR = 1477772;
    public static final int COLOR_ILLUSIONER_COAT = 3898306;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registryLookupFuture;

    public LooniumEquipmentLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.registryLookupFuture = registryLookupFuture;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.registryLookupFuture.thenCompose(registryLookup -> this.run(cache, (HolderLookup.Provider)registryLookup));
    }

    private CompletableFuture<?> run(@NotNull CachedOutput cache, HolderLookup.Provider registryLookup) {
        HolderLookup.RegistryLookup patternRegistry = registryLookup.lookupOrThrow(Registries.TRIM_PATTERN);
        HolderLookup.RegistryLookup materialRegistry = registryLookup.lookupOrThrow(Registries.TRIM_MATERIAL);
        BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory = (pattern, material) -> LooniumEquipmentLootProvider.getTrim((HolderLookup.RegistryLookup<TrimPattern>)patternRegistry, (HolderLookup.RegistryLookup<TrimMaterial>)materialRegistry, (ResourceKey<TrimPattern>)pattern, (ResourceKey<TrimMaterial>)material);
        BiConsumer<ArmorTrim, CompoundTag> trimSetter = (trim, tag) -> LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).accept((CompoundTag)tag);
        BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory = (trim, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim), true, (Item)armorItems);
        TriFunction randomizedDyedSetFactory = (trim, color, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).andThen(LooniumEquipmentLootProvider.addDyedColorToTag(color)), true, (Item)armorItems);
        TriFunction fixedDyedSetFactory = (trim, color, armorItems) -> this.createArmorSet(LooniumEquipmentLootProvider.addTrimToTag(registryLookup, trim).andThen(LooniumEquipmentLootProvider.addDyedColorToTag(color)), false, (Item)armorItems);
        Map<ArmorMaterials, Item[]> armorItems2 = Map.of(ArmorMaterials.LEATHER, new Item[]{Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS}, ArmorMaterials.CHAIN, new Item[]{Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS}, ArmorMaterials.IRON, new Item[]{Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS}, ArmorMaterials.GOLD, new Item[]{Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS}, ArmorMaterials.DIAMOND, new Item[]{Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS}, ArmorMaterials.NETHERITE, new Item[]{Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS});
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        this.defineWeaponEquipmentTables(tables);
        this.defineAncientCityEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineBastionRemnantEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineDesertPyramidEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineEndCityEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineJungleTempleEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineFortressEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineOceanMonumentEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory, (TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder>)randomizedDyedSetFactory);
        this.definePillagerOutpostEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineRuinedPortalEquipmentTables(tables);
        this.defineShipwreckEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineStrongholdEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory, trimSetter);
        this.defineTrailRuinsEquipmentTables(tables, armorItems2, trimFactory, randomizedSetFactory);
        this.defineWoodlandMansionEquipmentTables(tables, trimFactory, (TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder>)fixedDyedSetFactory, trimSetter);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(tables.size());
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.json((ResourceLocation)e.getKey());
            LootTable.Builder builder = (LootTable.Builder)e.getValue();
            LootTable lootTable = builder.setParamSet(LootContextParamSets.SELECTOR).build();
            JsonElement jsonTree = Deserializers.createLootTableSerializer().create().toJsonTree((Object)lootTable);
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void defineWeaponEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables) {
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_AXE))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_BOW, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CROSSBOW))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_SWORD).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_SWORD))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SWORD))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TRIDENT))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION, LootTable.lootTable().withPool(LootPool.lootPool().add(LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_AXE).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(this.getProfessionNbt(VillagerProfession.BUTCHER)))))).add(LootItem.lootTableItem((ItemLike)Items.IRON_HOE).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(this.getProfessionNbt(VillagerProfession.FARMER)))))).add(LootItem.lootTableItem((ItemLike)Items.FISHING_ROD).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(this.getProfessionNbt(VillagerProfession.FISHERMAN)))))).add(LootItem.lootTableItem((ItemLike)Items.IRON_PICKAXE).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(this.getProfessionNbt(VillagerProfession.TOOLSMITH)))))).add(LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(this.getProfessionNbt(VillagerProfession.WEAPONSMITH))))))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW))));
        tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)-1.0f, (float)1.0f)).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_SWORD)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW))));
    }

    private CompoundTag getProfessionNbt(VillagerProfession profession) {
        CompoundTag villagerDataTag = new CompoundTag();
        BuiltInRegistries.VILLAGER_PROFESSION.byNameCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)profession).resultOrPartial(arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0)).ifPresent(data -> villagerDataTag.put("profession", data));
        CompoundTag tag = new CompoundTag();
        tag.put("VillagerData", (Tag)villagerDataTag);
        return tag;
    }

    private void defineAncientCityEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimWardQuartz = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.WARD, (ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ);
        ArmorTrim trimSilenceCopper = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SILENCE, (ResourceKey<TrimMaterial>)TrimMaterials.COPPER);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON, randomizedSetFactory.apply(trimWardQuartz, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND, randomizedSetFactory.apply(trimWardQuartz, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD, randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND, randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag darknessEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.DARKNESS, 200);
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON).setWeight(11)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND).setWeight(5)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND).setWeight(1))).withPool(LootPool.lootPool().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{Items.BOW}).build()).build()))).when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TIPPED_ARROW).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)darknessEffectTag)))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY))));
    }

    private void defineBastionRemnantEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSnoutGold = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SNOUT, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD);
        ArmorTrim trimSnoutNetherite = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SNOUT, (ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD, randomizedSetFactory.apply(trimSnoutNetherite, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE, randomizedSetFactory.apply(trimSnoutGold, armorItems.get(ArmorMaterials.NETHERITE)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD).setWeight(4)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT))));
    }

    private void defineDesertPyramidEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimDuneRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.DUNE, (ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND, randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON).setWeight(5)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID))));
    }

    private void defineEndCityEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSpireAmethyst = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SPIRE, (ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND, randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag levitationEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.LEVITATION, 200);
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_END_CITY, LootTable.lootTable().withPool(LootPool.lootPool().apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND).setWeight(2))).withPool(LootPool.lootPool().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)EntityType.SKELETON)))).when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TIPPED_ARROW).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)levitationEffectTag)))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_END_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_END_CITY))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_END_CITY))));
    }

    private static CompoundTag getPotionEffectTag(MobEffect mobEffect, int duration) {
        ListTag effects = new ListTag();
        effects.add((Object)new MobEffectInstance(mobEffect, duration).save(new CompoundTag()));
        CompoundTag effectTag = new CompoundTag();
        effectTag.put("CustomPotionEffects", (Tag)effects);
        effectTag.putInt("CustomPotionColor", mobEffect.getColor());
        return effectTag;
    }

    private void defineFortressEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimRibIron = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.RIB, (ResourceKey<TrimMaterial>)TrimMaterials.IRON);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND, randomizedSetFactory.apply(trimRibIron, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_FORTRESS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON).setWeight(7)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND).setWeight(2))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_FORTRESS))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_FORTRESS))));
    }

    private void defineJungleTempleEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimWildEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.WILD, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND, randomizedSetFactory.apply(trimWildEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN).setWeight(4)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE))));
    }

    private void defineOceanMonumentEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory, TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder> randomizedDyedSetFactory) {
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER, (LootTable.Builder)randomizedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.TIDE, (ResourceKey<TrimMaterial>)TrimMaterials.COPPER), (Object)1481884, (Object)armorItems.get(ArmorMaterials.LEATHER)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD, randomizedSetFactory.apply(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.TIDE, (ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND), armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND, randomizedSetFactory.apply(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.TIDE, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD), armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_MONUMENT))));
    }

    private void definePillagerOutpostEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimSentryEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SENTRY, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND, randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_OUTPOST, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN).setWeight(5)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_OUTPOST))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_OUTPOST))));
    }

    private void defineRuinedPortalEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables) {
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_PORTAL, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_HELMET)).setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_CHESTPLATE)).setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_LEGGINGS)).setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_BOOTS)).setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_PORTAL, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))));
        tables.put(BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_PORTAL, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_PORTAL))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD))));
    }

    private void defineShipwreckEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimCoastEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.COAST, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND, randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN).setWeight(4)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON).setWeight(4)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK))));
    }

    private void defineStrongholdEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory, BiConsumer<ArmorTrim, CompoundTag> trimSetter) {
        ArmorTrim trimEyeRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.EYE, (ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE);
        ArmorTrim trimEyeLapis = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.EYE, (ResourceKey<TrimMaterial>)TrimMaterials.LAPIS);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON, randomizedSetFactory.apply(trimEyeLapis, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD, randomizedSetFactory.apply(trimEyeRedstone, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND, randomizedSetFactory.apply(trimEyeLapis, armorItems.get(ArmorMaterials.DIAMOND)));
        CompoundTag endermanHeadTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.EYE, (ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST), endermanHeadTag);
        LooniumEquipmentLootProvider.addDyedColorToTag(0x1D1D21).accept(endermanHeadTag);
        CompoundTag endermanBodyTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(0x1D1D21).accept(endermanBodyTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_HELMET).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)endermanHeadTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)endermanBodyTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)endermanBodyTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)endermanBodyTag)))));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON).setWeight(5)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN).setWeight(1))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD))));
    }

    private void defineTrailRuinsEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, Map<ArmorMaterial, Item[]> armorItems, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, BiFunction<ArmorTrim, Item[], LootTable.Builder> randomizedSetFactory) {
        ArmorTrim trimHostEmerald = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.HOST, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN, randomizedSetFactory.apply(trimHostEmerald, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON, randomizedSetFactory.apply(trimHostEmerald, armorItems.get(ArmorMaterials.IRON)));
        ArmorTrim trimRaiserAmethyst = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.RAISER, (ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON, randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(ArmorMaterials.IRON)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD, randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(ArmorMaterials.GOLD)));
        ArmorTrim trimShaperLapis = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.SHAPER, (ResourceKey<TrimMaterial>)TrimMaterials.LAPIS);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD, randomizedSetFactory.apply(trimShaperLapis, armorItems.get(ArmorMaterials.GOLD)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND, randomizedSetFactory.apply(trimShaperLapis, armorItems.get(ArmorMaterials.DIAMOND)));
        ArmorTrim trimWayfinderRedstone = trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.WAYFINDER, (ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN, randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(ArmorMaterials.CHAIN)));
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND, randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(ArmorMaterials.DIAMOND)));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN).setWeight(7)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN).setWeight(7)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON).setWeight(8)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON).setWeight(8)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD).setWeight(3)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND).setWeight(2))));
        tables.put(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_TRIDENT))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
        tables.put(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_BOW))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
        tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_WEAPON_SWORD))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS))));
    }

    private void defineWoodlandMansionEquipmentTables(Map<ResourceLocation, LootTable.Builder> tables, BiFunction<ResourceKey<TrimPattern>, ResourceKey<TrimMaterial>, ArmorTrim> trimFactory, TriFunction<ArmorTrim, Integer, Item[], LootTable.Builder> fixedDyedSetFactory, BiConsumer<ArmorTrim, CompoundTag> trimSetter) {
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER, ((LootTable.Builder)fixedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD), (Object)3290681, (Object)new Item[]{Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS})).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.2f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TOTEM_OF_UNDYING))));
        CompoundTag vindicatorChestTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE), vindicatorChestTag);
        LooniumEquipmentLootProvider.addDyedColorToTag(4673362).accept(vindicatorChestTag);
        CompoundTag vindicatorLegsTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(1477772).accept(vindicatorLegsTag);
        CompoundTag vindicatorBootsTag = new CompoundTag();
        LooniumEquipmentLootProvider.addDyedColorToTag(3290681).accept(vindicatorBootsTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)vindicatorChestTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)vindicatorLegsTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)vindicatorBootsTag)))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))))));
        CompoundTag blindnessEffectTag = LooniumEquipmentLootProvider.getPotionEffectTag(MobEffects.BLINDNESS, 100);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER, ((LootTable.Builder)fixedDyedSetFactory.apply((Object)trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.LAPIS), (Object)3898306, (Object)new Item[]{Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS})).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))))).withPool(LootPool.lootPool().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)EntityType.SKELETON)))).when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TIPPED_ARROW).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)blindnessEffectTag)))));
        CompoundTag vexHeadTag = new CompoundTag();
        trimSetter.accept(trimFactory.apply((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST), vexHeadTag);
        tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_HELMET).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)vexHeadTag)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_CHESTPLATE))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_LEGGINGS))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.9f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_SWORD).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment().when(LootItemRandomChanceCondition.randomChance((float)0.3f))))));
        tables.put(BotaniaLootTables.LOONIUM_ARMOR_MANSION, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR).setWeight(2)).add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER).setWeight(1)).add(LootTableReference.lootTableReference((ResourceLocation)BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX).setWeight(45).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.randomChance((float)0.005f), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setIsBaby(Boolean.valueOf(true)).build()))})))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TOTEM_OF_UNDYING))));
    }

    private static ArmorTrim getTrim(HolderLookup.RegistryLookup<TrimPattern> patternRegistry, HolderLookup.RegistryLookup<TrimMaterial> materialRegistry, ResourceKey<TrimPattern> pattern, ResourceKey<TrimMaterial> material) {
        Holder.Reference tidePattern = (Holder.Reference)patternRegistry.get(pattern).orElseThrow();
        Holder.Reference goldMaterial = (Holder.Reference)materialRegistry.get(material).orElseThrow();
        return new ArmorTrim((Holder)goldMaterial, (Holder)tidePattern);
    }

    private static Consumer<CompoundTag> addTrimToTag(HolderLookup.Provider registryLookup, ArmorTrim trim) {
        return tag -> tag.put("Trim", (Tag)ArmorTrim.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryLookup), (Object)trim).result().orElseThrow());
    }

    private static Consumer<CompoundTag> addDyedColorToTag(int color) {
        CompoundTag displayTag = new CompoundTag();
        displayTag.putInt("color", color);
        return tag -> tag.put("display", (Tag)displayTag);
    }

    private LootTable.Builder createArmorSet(Consumer<CompoundTag> tagModifier, boolean randomized, Item ... armorItems) {
        CompoundTag tag = new CompoundTag();
        tagModifier.accept(tag);
        LootTable.Builder lootTable = LootTable.lootTable();
        for (Item armorItem : armorItems) {
            lootTable.withPool(LootPool.lootPool().setRolls((NumberProvider)(randomized ? UniformGenerator.between((float)0.0f, (float)1.0f) : ConstantValue.exactly((float)1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)armorItem).apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)tag))));
        }
        return lootTable;
    }

    @NotNull
    public String getName() {
        return "Equipment tables for Loonium-spawned mobs";
    }
}

