/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BotanicalBreweryEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefix("textures/gui/nei_brewery.png");
    private final List<EmiIngredient> ingredients;
    private final ResourceLocation id;

    public BotanicalBreweryEmiRecipe(BotanicalBreweryRecipe recipe, ItemStack container) {
        super(BotaniaEmiPlugin.BOTANICAL_BREWERY, recipe);
        this.ingredients = recipe.getIngredients().stream().map(EmiIngredient::of).toList();
        this.input = Stream.concat(Stream.of(EmiStack.of((ItemStack)container)), this.ingredients.stream()).toList();
        this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput(container.copy())));
        ResourceLocation id = recipe.getId();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)container.getItem());
        this.id = new ResourceLocation("emi", "botania/botanical_brewery/" + id.getNamespace() + "/" + id.getPath() + "/" + itemId.getNamespace() + "/" + itemId.getPath());
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public int getDisplayHeight() {
        return 65;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 0, 0, 86, 55, 28, 6));
        widgets.addSlot((EmiIngredient)this.input.get(this.output.size() - 1), 10, 35);
        int sx = 58 - (this.ingredients.size() - 1) * 9;
        for (EmiIngredient stack : this.ingredients) {
            widgets.addSlot(stack, sx, 1).drawBack(false);
            sx += 18;
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 58, 35).recipeContext((EmiRecipe)this);
    }
}

