/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.BotaniaConfig;

public final class ManaTabletRenderHandler extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {

	public ManaTabletRenderHandler(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
		super(renderer);
	}

	@Override
	public void render(PoseStack ms, MultiBufferSource buffers, int light, @NotNull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		if (BotaniaConfig.client().renderAccessories() && !player.isInvisible()) {
			renderManaTablet(ms, buffers, player);
		}
	}

	private void renderManaTablet(PoseStack ms, MultiBufferSource buffers, Player player) {
		boolean renderedOne = false;
		for (int i = 0; i < player.getInventory().getContainerSize(); i++) {
			ItemStack stack = player.getInventory().getItem(i);
			if (!stack.isEmpty() && stack.is(BotaniaItems.manaTablet)) {
				ms.pushPose();
				boolean armor = !player.getItemBySlot(EquipmentSlot.LEGS).isEmpty();

				getParentModel().body.translateAndRotate(ms);
				ms.translate(0, 0.65, 0);
				if (renderedOne) {
					ms.translate(armor ? 0.3 : 0.25, 0, 0);
					ms.mulPose(VecHelper.rotateY(-90F));
				} else {
					ms.translate(armor ? -0.3 : -0.25, 0, 0);
					ms.mulPose(VecHelper.rotateY(90F));
				}

				ms.scale(0.375F, -0.375F, -0.375F);
				Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE,
						0xF000F0, OverlayTexture.NO_OVERLAY, ms, buffers, player.level(), player.getId());
				ms.popPose();

				if (renderedOne) {
					return;
				}
				renderedOne = true;
			}
		}
	}
}
