/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlock;

public class ManaDetectorBlock
extends BotaniaBlock
implements ManaCollisionGhost {
    public ManaDetectorBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? 15 : 0;
    }

    @Override
    public ManaCollisionGhost.Behaviour getGhostBehaviour() {
        return ManaCollisionGhost.Behaviour.RUN_RECEIVER_TRIGGER;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && !state.is(oldState.getBlock()) && ((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && !level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 18);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            for (int i = 0; i < 4; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle(0.7f + 0.5f * (float)Math.random(), 1.0f, 0.2f, 0.2f, 5);
                level.addParticle((ParticleOptions)data, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static class ManaTriggerImpl
    implements ManaTrigger {
        private final Level world;
        private final BlockPos pos;
        private final BlockState state;

        public ManaTriggerImpl(Level world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        @Override
        public void onBurstCollision(ManaBurst burst) {
            if (!(this.world.isClientSide || burst.isFake() || ((Boolean)this.state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || this.world.getBlockTicks().hasScheduledTick(this.pos, (Object)this.state.getBlock()))) {
                this.world.setBlockAndUpdate(this.pos, (BlockState)this.state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
                this.world.scheduleTick(this.pos, this.state.getBlock(), 4);
            }
        }
    }
}

