/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlock;

public class BotaniaGrassBlock
extends BotaniaBlock {
    private final Variant variant;

    public BotaniaGrassBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isClientSide && state.is((Block)this) && world.getMaxLocalRawBrightness(pos.above()) >= 9) {
            for (int l = 0; l < 4; ++l) {
                BlockPos pos1 = pos.offset(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                BlockPos pos1up = pos1.above();
                if (!world.getBlockState(pos1).is(Blocks.DIRT) || world.getMaxLocalRawBrightness(pos1up) < 4 || world.getBlockState(pos1up).getLightBlock((BlockGetter)world, pos1up) > 2) continue;
                world.setBlockAndUpdate(pos1, this.defaultBlockState());
            }
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource r) {
        switch (this.variant) {
            case DRY: {
                break;
            }
            case GOLDEN: {
                break;
            }
            case VIVID: {
                break;
            }
            case SCORCHED: {
                if (r.nextInt(80) != 0) break;
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + r.nextFloat()), (double)pos.getY() + 1.1, (double)((float)pos.getZ() + r.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
            case INFUSED: {
                if (r.nextInt(100) != 0) break;
                SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 0.0f, 1.0f, 1.0f, 5);
                world.addParticle((ParticleOptions)data, (double)((float)pos.getX() + r.nextFloat()), (double)pos.getY() + 1.05, (double)((float)pos.getZ() + r.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
            case MUTATED: {
                if (r.nextInt(100) != 0) break;
                if (r.nextInt(100) > 25) {
                    SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 1.0f, 0.0f, 1.0f, 5);
                    world.addParticle((ParticleOptions)data, (double)((float)pos.getX() + r.nextFloat()), (double)pos.getY() + 1.05, (double)((float)pos.getZ() + r.nextFloat()), 0.0, 0.0, 0.0);
                    break;
                }
                SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 1.0f, 1.0f, 0.0f, 5);
                world.addParticle((ParticleOptions)data, (double)((float)pos.getX() + r.nextFloat()), (double)pos.getY() + 1.05, (double)((float)pos.getZ() + r.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    public static enum Variant {
        DRY,
        GOLDEN,
        VIVID,
        SCORCHED,
        INFUSED,
        MUTATED;

    }
}

