/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public record SpawnGaiaGuardianPacket(ClientboundAddEntityPacket inner, int playerCount, boolean hardMode, BlockPos source, UUID bossInfoId) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("spg");

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.inner().write(buf);
        buf.writeVarInt(this.playerCount());
        buf.writeBoolean(this.hardMode());
        buf.writeBlockPos(this.source());
        buf.writeUUID(this.bossInfoId());
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static SpawnGaiaGuardianPacket decode(FriendlyByteBuf buf) {
        return new SpawnGaiaGuardianPacket(new ClientboundAddEntityPacket(buf), buf.readVarInt(), buf.readBoolean(), buf.readBlockPos(), buf.readUUID());
    }

    public static class Handler {
        public static void handle(SpawnGaiaGuardianPacket packet) {
            ClientboundAddEntityPacket inner = packet.inner();
            int playerCount = packet.playerCount();
            boolean hardMode = packet.hardMode();
            BlockPos source = packet.source();
            UUID bossInfoUuid = packet.bossInfoId();
            Minecraft.getInstance().execute(() -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.connection.handleAddEntity(inner);
                    Entity e = player.level().getEntity(inner.getId());
                    if (e instanceof GaiaGuardianEntity) {
                        GaiaGuardianEntity dopple = (GaiaGuardianEntity)e;
                        dopple.readSpawnData(playerCount, hardMode, source, bossInfoUuid);
                    }
                }
            });
        }
    }
}

