/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;

public class LuminizerLauncherBlock
extends BotaniaWaterloggedBlock {
    private static final VoxelShape SHAPE = LuminizerLauncherBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public LuminizerLauncherBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.getBestNeighborSignal(pos) > 0;
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (power && !powered) {
            this.pickUpEntities(world, pos);
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void pickUpEntities(Level world, BlockPos pos) {
        LuminizerBlockEntity relay;
        ArrayList<LuminizerBlockEntity> relays = new ArrayList<LuminizerBlockEntity>();
        for (Direction dir : Direction.values()) {
            BlockEntity tile = world.getBlockEntity(pos.relative(dir));
            if (!(tile instanceof LuminizerBlockEntity) || (relay = (LuminizerBlockEntity)tile).getNextDestination() == null) continue;
            relays.add(relay);
        }
        if (!relays.isEmpty()) {
            AABB aabb = new AABB(pos, pos.offset(1, 1, 1));
            List living = world.getEntitiesOfClass(LivingEntity.class, aabb);
            List items = world.getEntitiesOfClass(ItemEntity.class, aabb);
            for (Entity entity : Iterables.concat((Iterable)living, (Iterable)items)) {
                relay = (LuminizerBlockEntity)relays.get(world.random.nextInt(relays.size()));
                relay.mountEntity(entity);
            }
        }
    }
}

