/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class RunicAltarBlockEntityRenderer
implements BlockEntityRenderer<RunicAltarBlockEntity> {
    private final ModelPart spinningCube;
    private static final ResourceLocation cubeTex = ResourceLocationHelper.prefix("textures/block/runic_altar_cube.png");

    public RunicAltarBlockEntityRenderer(BlockEntityRendererProvider.Context manager) {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("cube", CubeListBuilder.create().addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        this.spinningCube = LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16).bakeRoot();
    }

    public void render(@NotNull RunicAltarBlockEntity altar, float partticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float scale;
        ms.pushPose();
        int items = 0;
        for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().getItem(i).isEmpty(); ++i) {
            ++items;
        }
        float[] angles = new float[altar.inventorySize()];
        float anglePer = 360.0f / (float)items;
        float totalAngle = 0.0f;
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = totalAngle += anglePer;
        }
        double time = (float)ClientTickHandler.ticksInGame + partticks;
        for (int i = 0; i < altar.inventorySize(); ++i) {
            ms.pushPose();
            ms.translate(0.5f, 1.25f, 0.5f);
            ms.mulPose(VecHelper.rotateY(angles[i] + (float)time));
            ms.translate(1.125f, 0.0f, 0.25f);
            ms.mulPose(VecHelper.rotateY(90.0f));
            ms.translate(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
            ItemStack stack = altar.getItemHandler().getItem(i);
            Minecraft mc = Minecraft.getInstance();
            if (!stack.isEmpty()) {
                mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffers, altar.getLevel(), 0);
            }
            ms.popPose();
        }
        ms.pushPose();
        ms.translate(0.5f, 0.5f, 0.5f);
        this.renderSpinningCubes(ms, buffers, overlay, 2, 15);
        ms.popPose();
        ms.translate(0.0f, 0.2f, 0.0f);
        float f = scale = altar.getTargetMana() == 0 ? 0.0f : (float)altar.getCurrentMana() / (float)altar.getTargetMana() / 75.0f;
        if (scale != 0.0f) {
            int seed = altar.getBlockPos().getX() ^ altar.getBlockPos().getY() ^ altar.getBlockPos().getZ();
            ms.translate(0.5f, 0.7f, 0.5f);
            RenderHelper.renderStar(ms, buffers, 58583, scale, scale, scale, seed);
        }
        ms.popPose();
    }

    private void renderSpinningCubes(PoseStack ms, MultiBufferSource buffers, int overlay, int cubes, int iters) {
        for (int curIter = iters; curIter > 0; --curIter) {
            float modifier = 6.0f;
            float rotationModifier = 0.2f;
            float radiusBase = 0.35f;
            float radiusMod = 0.05f;
            double ticks = (double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) - 1.3 * (double)(iters - curIter);
            float offsetPerCube = 360 / cubes;
            ms.pushPose();
            ms.translate(-0.025f, 0.85f, -0.025f);
            for (int i = 0; i < cubes; ++i) {
                float offset = offsetPerCube * (float)i;
                float deg = (int)(ticks / (double)0.2f % 360.0 + (double)offset);
                float rad = VecHelper.toRadians(deg);
                float radiusX = (float)((double)0.35f + (double)0.05f * Math.sin(ticks / 6.0));
                float radiusZ = (float)((double)0.35f + (double)0.05f * Math.cos(ticks / 6.0));
                float x = (float)((double)radiusX * Math.cos(rad));
                float z = (float)((double)radiusZ * Math.sin(rad));
                float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                ms.pushPose();
                ms.translate(x, y, z);
                float xRotate = (float)Math.sin(ticks * (double)0.2f) / 2.0f;
                float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                float zRotate = (float)Math.cos(ticks * (double)0.2f) / 2.0f;
                ms.mulPose(new Quaternionf().rotateAxis(rad, xRotate, yRotate, zRotate));
                float alpha = 1.0f;
                if (curIter < iters) {
                    alpha = (float)curIter / (float)iters * 0.4f;
                }
                VertexConsumer buffer = buffers.getBuffer(curIter < iters ? RenderType.entityTranslucentCull((ResourceLocation)cubeTex) : RenderType.entitySolid((ResourceLocation)cubeTex));
                this.spinningCube.render(ms, buffer, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, alpha);
                ms.popPose();
            }
            ms.popPose();
        }
    }
}

